/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.Tuple2;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO8859_15 = Charset.forName("ISO-8859-15");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final Pattern quotePatrn = Pattern.compile("\"", 16);
    private static final Pattern slashPatrn = Pattern.compile("(\\\\+)");

    public static String firstUp(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static final int getLeastMaximum() {
        return Shortener.ORDERED[Shortener.ORDERED.length - 1].getMinStringLength();
    }

    private static final Shortener getShortener(int l) {
        Shortener[] shortenerArray = Shortener.ORDERED;
        int n = Shortener.ORDERED.length;
        int n2 = 0;
        while (n2 < n) {
            Shortener sh = shortenerArray[n2];
            if (l >= sh.getMinStringLength()) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public static final String getBoundedLengthString(String s, int maxLength) throws IllegalArgumentException {
        if (maxLength < StringUtils.getLeastMaximum()) {
            throw new IllegalArgumentException("Maximum too low : " + maxLength + "<" + StringUtils.getLeastMaximum());
        }
        String res = s.length() <= maxLength ? s : StringUtils.getShortener(maxLength).shorten(s, maxLength);
        return res;
    }

    private static String getTooWideString(String s, int width, boolean allowShorten) {
        assert (s.length() > width);
        if (!allowShorten) {
            throw new IllegalArgumentException("Too wide : " + s.length() + " > " + width);
        }
        return StringUtils.getBoundedLengthString(s, width);
    }

    public static StringBuilder appendFixedWidthString(StringBuilder sb, String s, int width, Side align, char filler, boolean allowShorten) {
        int origBuilderLen = sb.length();
        int length = s.length();
        if (length <= width) {
            sb.ensureCapacity(origBuilderLen + width);
            if (align == Side.LEFT) {
                sb.append(s);
            }
            int i = length;
            while (i < width) {
                sb.append(filler);
                ++i;
            }
            if (align == Side.RIGHT) {
                sb.append(s);
            }
        } else {
            sb.append(StringUtils.getTooWideString(s, width, allowShorten));
        }
        assert (sb.length() == origBuilderLen + width);
        return sb;
    }

    public static int firstIndexOf(String s, int offset, char[] chars) {
        int res = -1;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int index = s.indexOf(c, offset);
            if (index >= 0 && (res == -1 || index < res)) {
                res = index;
            }
            ++n2;
        }
        return res;
    }

    public static String doubleQuote(String s) {
        return StringUtils.doubleQuote(s, true);
    }

    public static String doubleQuote(String s, boolean escapeEscapeChar) {
        if (s.length() > 0) {
            if (escapeEscapeChar) {
                s = slashPatrn.matcher(s).replaceAll("$1$1");
            }
            s = quotePatrn.matcher(s).replaceAll("\\\\\"");
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static String unDoubleQuote(String s) {
        Tuple2<String, Integer> res = StringUtils.unDoubleQuote(s, 0);
        if (res.get1().intValue() != s.length()) {
            throw new IllegalArgumentException("Extra content at the end : " + s.substring(res.get1()));
        }
        return res.get0();
    }

    public static Tuple2<String, Integer> unDoubleQuote(String s, int offset) {
        if (s.charAt(offset) != '\"') {
            throw new IllegalArgumentException("Expected quote but got : " + s.charAt(offset));
        }
        int l = s.length();
        if (offset + 1 < l && s.charAt(offset + 1) == '\"') {
            return Tuple2.create("", offset + 2);
        }
        ++offset;
        char[] chars = new char[]{'\"', '\\'};
        StringBuilder sb = new StringBuilder(512);
        boolean foundEnd = false;
        while (offset < l && !foundEnd) {
            int index = StringUtils.firstIndexOf(s, offset, chars);
            if (index < 0) {
                throw new IllegalArgumentException("End quote not found after " + offset);
            }
            sb.append(s.substring(offset, index));
            if (s.charAt(index) == '\"') {
                offset = index + 1;
                foundEnd = true;
                continue;
            }
            assert (s.charAt(index) == '\\');
            sb.append(s.charAt(index + 1));
            offset = index + 2;
        }
        if (!foundEnd) {
            throw new IllegalArgumentException("End quote not found after " + offset);
        }
        return Tuple2.create(sb.toString(), offset);
    }

    public static boolean isEmpty(String s) {
        return StringUtils.isEmpty(s, false);
    }

    public static boolean isEmpty(String s, boolean trim) {
        return s == null || (trim ? s.trim() : s).isEmpty();
    }

    public static String coalesce(String s1, String s2) {
        return StringUtils.isEmpty(s1) ? s2 : s1;
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char esc, char name) {
            this.esc = esc;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(esc, name);
        }

        public Escaper add(char toRemove, char escapedName) {
            if (this.inv.containsKey(Character.valueOf(escapedName))) {
                throw new IllegalArgumentException(String.valueOf(escapedName) + " already replaces " + this.inv.get(Character.valueOf(escapedName)));
            }
            this.substitution.put(Character.valueOf(toRemove), Character.valueOf(escapedName));
            this.inv.put(Character.valueOf(escapedName), Character.valueOf(toRemove));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> res = new HashSet<Character>(this.substitution.keySet());
            res.remove(Character.valueOf(this.esc));
            return res;
        }

        public final String escape(String s) {
            String res = s;
            for (Character toEsc : this.substitution.keySet()) {
                res = res.replace("" + toEsc, this.getEscaped(toEsc));
            }
            return res;
        }

        private String getEscaped(Character toEsc) {
            return String.valueOf(this.esc) + this.substitution.get(toEsc);
        }

        public final String unescape(String escaped) {
            String res = escaped;
            ArrayList<Character> toEscs = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(toEscs);
            for (Character toEsc : toEscs) {
                res = res.replaceAll(this.getEscaped(toEsc), "" + toEsc);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Escaper) {
                Escaper o = (Escaper)obj;
                return this.esc == o.esc && this.substitution.equals(o.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + this.substitution.hashCode();
        }
    }

    public static abstract class Shortener {
        private final int hashSize;
        private final int hashPartSize;
        private final String prefix;
        private final String suffix;
        private final int minStringLength;
        public static final Shortener Ellipsis = new Shortener(1, "", "", 1){

            @Override
            protected String shorten(String s) {
                return "\u2026";
            }
        };
        public static final Shortener JavaHashCode = new Shortener(8, "#", "#", 3){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.asHex(MessageDigestUtils.int2bytes(s.hashCode()));
            }
        };
        public static final Shortener MD5 = new Shortener(32, "#", "#", 11){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), s.getBytes(UTF8));
            }
        };
        static final Shortener[] ORDERED = new Shortener[]{MD5, JavaHashCode, Ellipsis};

        protected Shortener(int hashSize, String prefix, String suffix, int minCharsBeforeAndAfter) {
            this.hashSize = hashSize;
            this.prefix = prefix;
            this.suffix = suffix;
            this.hashPartSize = this.hashSize + this.prefix.length() + this.suffix.length();
            if (minCharsBeforeAndAfter < 1) {
                throw new IllegalArgumentException("minCharsBeforeAndAfter must be at least 1: " + minCharsBeforeAndAfter);
            }
            this.minStringLength = this.hashPartSize + minCharsBeforeAndAfter * 2;
        }

        public final int getMinStringLength() {
            return this.minStringLength;
        }

        final String shorten(String s, int maxLength) {
            assert (s.length() >= this.getMinStringLength());
            int toRemoveLength = s.length() - maxLength + this.hashPartSize;
            int toRemoveStartIndex = s.length() / 2 - toRemoveLength / 2;
            String toHash = s.substring(toRemoveStartIndex, toRemoveStartIndex + toRemoveLength);
            String hash = this.shorten(toHash);
            assert (this.hashSize == hash.length());
            String res = String.valueOf(s.substring(0, toRemoveStartIndex)) + this.prefix + hash + this.suffix + s.substring(toRemoveStartIndex + toRemoveLength);
            assert (res.length() == maxLength);
            return res;
        }

        protected abstract String shorten(String var1);
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

