/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String asHex(byte[] hash) {
        return MessageDigestUtils.toString(hash, HEX_CHARS);
    }

    public static String toString(byte[] hash, char[] chars) {
        char[] buf = new char[hash.length * 2];
        int i = 0;
        int x = 0;
        while (i < hash.length) {
            buf[x++] = chars[hash[i] >>> 4 & 0xF];
            buf[x++] = chars[hash[i] & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public static byte[] int2bytes(int integer) {
        byte[] byteStr = new byte[]{(byte)(integer >>> 24), (byte)(integer >>> 16 & 0xFF), (byte)(integer >>> 8 & 0xFF), (byte)(integer & 0xFF)};
        return byteStr;
    }

    public static String getHashString(MessageDigest md) {
        return MessageDigestUtils.asHex(md.digest());
    }

    public static String getHashString(MessageDigest md, byte[] data) {
        md.update(data);
        return MessageDigestUtils.getHashString(md);
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 is part of the standard JRE", e);
        }
    }
}

