/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JImage
extends JComponent {
    private Image image;
    private ImageIcon icon;
    private boolean centered;

    public JImage(ImageIcon img) {
        this(img.getImage());
        this.icon = img;
    }

    public JImage(Image img) {
        this.image = img;
        this.icon = null;
        this.setOpaque(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int dx;
        int dy;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (!this.centered) {
            dy = 0;
            dx = 0;
        } else {
            dx = (this.getWidth() - this.image.getWidth(null)) / 2;
            dy = (this.getHeight() - this.image.getHeight(null)) / 2;
        }
        g.drawImage(this.image, dx, dy, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }
}

