/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.StreamUtils;

public abstract class DesktopEnvironment {
    private static DesktopEnvironment DE = null;
    private String version = null;

    private static final String detectXDG() {
        String res;
        block13: {
            res = null;
            InputStream scriptIns = null;
            try {
                try {
                    scriptIns = DesktopEnvironment.class.getResourceAsStream("DesktopEnvironmentXDG.sh");
                    Process ps = new ProcessBuilder("sh").start();
                    ps.getErrorStream().close();
                    StreamUtils.copy(scriptIns, ps.getOutputStream());
                    ps.getOutputStream().close();
                    res = FileUtils.readUTF8(ps.getInputStream()).trim();
                    ps.getInputStream().close();
                    if (ps.waitFor() != 0) {
                        throw new IllegalStateException("Not OK : " + ps.exitValue());
                    }
                }
                catch (Exception e) {
                    Log.get().fine(e.getLocalizedMessage());
                    if (scriptIns == null) break block13;
                    try {
                        scriptIns.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (scriptIns != null) {
                    try {
                        scriptIns.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return res;
    }

    private static final DesktopEnvironment detectDE() {
        OSFamily os = OSFamily.getInstance();
        if (os == OSFamily.Windows) {
            return new Windows();
        }
        if (os == OSFamily.Mac) {
            return new Mac();
        }
        if (os instanceof OSFamily.Unix) {
            String de = DesktopEnvironment.detectXDG();
            if (de.equals("xfce")) {
                return new XFCE();
            }
            if (de.equals("mate")) {
                return new MATE();
            }
            if (de.equals("kde")) {
                return new KDE();
            }
            if (de.startsWith("gnome")) {
                return new Gnome(de);
            }
        }
        return new Unknown();
    }

    public static final DesktopEnvironment getDE() {
        if (DE == null) {
            DE = DesktopEnvironment.detectDE();
        }
        return DE;
    }

    private DesktopEnvironment() {
    }

    public File getDocumentsFolder() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public File getPreferencesFolder(String appName) {
        return new File(System.getProperty("user.home"), "." + appName);
    }

    public String toString() {
        return "DesktopEnvironment " + this.getClass().getSimpleName();
    }

    /* synthetic */ DesktopEnvironment(DesktopEnvironment desktopEnvironment) {
        this();
    }

    private static class DEisOS
    extends DesktopEnvironment {
        private DEisOS() {
            super(null);
        }
    }

    public static final class Gnome
    extends DesktopEnvironment {
        private final String name;

        public Gnome(String name) {
            super(null);
            this.name = name;
        }
    }

    public static final class KDE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^KDE: (.*)$", 8);

        public KDE() {
            super(null);
        }
    }

    public static final class MATE
    extends DesktopEnvironment {
        public MATE() {
            super(null);
        }
    }

    public static final class Mac
    extends DEisOS {
        private static Class<?> FileManagerClass;
        private static Short kUserDomain;
        private static Method OSTypeToInt;

        private static Class<?> getFileManagerClass() {
            if (FileManagerClass == null) {
                try {
                    FileManagerClass = Class.forName("com.apple.eio.FileManager");
                    OSTypeToInt = FileManagerClass.getMethod("OSTypeToInt", String.class);
                    kUserDomain = (Short)FileManagerClass.getField("kUserDomain").get(null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return FileManagerClass;
        }

        @Override
        public File getDocumentsFolder() {
            return this.getFolder("docs");
        }

        @Override
        public File getPreferencesFolder(String appName) {
            return new File(this.getFolder("pref"), appName);
        }

        public File getFolder(String type) {
            try {
                Method findFolder = Mac.getFileManagerClass().getMethod("findFolder", Short.TYPE, Integer.TYPE);
                String path = (String)findFolder.invoke(null, kUserDomain, OSTypeToInt.invoke(null, type));
                return new File(path);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static final class Unknown
    extends DesktopEnvironment {
        public Unknown() {
            super(null);
        }
    }

    public static final class Windows
    extends DEisOS {
        private static final Pattern quotePatrn = Pattern.compile("([\\\\]*)\"");
        private static final Pattern endSlashPatrn = Pattern.compile("([\\\\]*)\\z");
    }

    public static final class XFCE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^xfce4-about.+\\(\\p{Alnum}+\\p{Blank}+(.+)\\)$", 8);

        public XFCE() {
            super(null);
        }
    }
}

