/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserSingleton;
import org.openconcerto.sql.users.UserSingletonManager;
import org.openconcerto.utils.ThreadFactory;

public class UserManager
implements UserSingleton {
    private static final UserSingletonManager<UserManager> sMngr = new UserSingletonManager<UserManager>("USER_COMMON"){

        @Override
        protected UserManager createInstance(SQLTable t) {
            return new UserManager(t).start();
        }
    };
    private final SQLTable t;
    private Map<Integer, User> byID = null;
    private long timeOfLastFill = -1L;
    private Integer currentUserID = null;
    private final SQLTableModifiedListener tableL;
    private ScheduledFuture<?> scheduledUpdateUsers;
    private Future<?> updateUsers;
    private Future<?> userFuture;
    private final ScheduledExecutorService exec;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public static UserSingletonManager<UserManager> getSingletonManager() {
        return sMngr;
    }

    public static final UserManager getInstance() {
        return UserManager.getSingletonManager().getInstance();
    }

    public static final User getUser() {
        UserManager mngr = UserManager.getInstance();
        return mngr == null ? null : mngr.getCurrentUser();
    }

    public static final int getUserID() {
        User user = UserManager.getUser();
        return user == null ? -1 : user.getId();
    }

    public UserManager(SQLTable t) {
        this.t = t;
        this.exec = Executors.newScheduledThreadPool(1, new ThreadFactory(String.valueOf(UserManager.class.getSimpleName()) + " executor for " + t.getSQLName(), true).setPriority(1));
        this.tableL = new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                UserManager.this.refresh(true);
            }
        };
    }

    public final UserManager start() {
        return this.start(480000L);
    }

    public final synchronized UserManager start(final long maxAge) {
        if (this.getState() != State.CREATED) {
            throw new IllegalStateException("Already started");
        }
        this.t.addTableModifiedListener(this.tableL);
        this.fillUsers();
        this.scheduledUpdateUsers = this.exec.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UserManager.this.refreshIfNeeded(maxAge);
            }
        }, maxAge / 4L, maxAge / 4L, TimeUnit.MILLISECONDS);
        return this;
    }

    public final boolean isValid() {
        return this.getState() == State.VALID;
    }

    public final synchronized State getState() {
        if (this.scheduledUpdateUsers == null) {
            return State.CREATED;
        }
        if (this.scheduledUpdateUsers.isDone()) {
            return State.DESTROYED;
        }
        return State.VALID;
    }

    @Override
    public final synchronized void destroy() {
        State s = this.getState();
        if (s == State.DESTROYED) {
            return;
        }
        if (s == State.VALID) {
            this.getTable().removeTableModifiedListener(this.tableL);
            this.scheduledUpdateUsers.cancel(true);
            this.cancelUpdate();
        }
        this.exec.shutdown();
        assert (this.getState() == State.DESTROYED);
    }

    private void cancelUpdate() {
        assert (Thread.holdsLock(this));
        if (this.updateUsers != null && (this.userFuture == null || this.userFuture.isDone())) {
            this.updateUsers.cancel(true);
        }
    }

    private boolean isUpdatePending() {
        assert (Thread.holdsLock(this));
        return this.updateUsers != null && !this.updateUsers.isDone();
    }

    private synchronized void refreshIfNeeded(long maxAge) {
        long dataAge = System.currentTimeMillis() - this.timeOfLastFill;
        if (dataAge > maxAge && !this.isUpdatePending()) {
            this.refresh(true);
        }
    }

    private synchronized void refresh(final boolean thisClass) {
        this.cancelUpdate();
        this.updateUsers = this.invokeLater(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (thisClass) {
                    Thread.sleep(30L);
                }
                UserManager.this.fillUsers();
                return null;
            }
        }, false);
        this.userFuture = null;
    }

    public final synchronized <T> Future<T> invokeLater(Callable<T> c, boolean needsPreviousUpdate) {
        if (!this.isValid()) {
            return null;
        }
        Future<T> res = this.exec.submit(c);
        if (needsPreviousUpdate) {
            this.userFuture = res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillUsers() {
        Map<Integer, User> old;
        LinkedHashMap<Integer, User> mutable = new LinkedHashMap<Integer, User>();
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(new SQLRowValues(this.t).setAllToNull());
        fetcher.setOrdered(true);
        for (SQLRowValues v : fetcher.fetch()) {
            User u = new User(v);
            mutable.put(v.getID(), u);
        }
        Map immutable = Collections.unmodifiableMap(mutable);
        UserManager userManager = this;
        synchronized (userManager) {
            old = this.byID;
            this.byID = immutable;
            this.timeOfLastFill = System.currentTimeMillis();
        }
        this.supp.firePropertyChange("users", old, immutable);
    }

    @Override
    public final SQLTable getTable() {
        return this.t;
    }

    public final synchronized Map<Integer, User> getUsers() {
        if (this.byID == null) {
            throw new IllegalStateException(this + " wasn't started successfully");
        }
        return this.byID;
    }

    public final synchronized User getCurrentUser() {
        return this.currentUserID == null ? null : this.getUser(this.currentUserID);
    }

    public User getUser(Integer v) {
        Map<Integer, User> users = this.getUsers();
        if (users.containsKey(v)) {
            return users.get(v);
        }
        throw new IllegalStateException("Bad user! " + v);
    }

    public static enum State {
        CREATED,
        VALID,
        DESTROYED;

    }
}

