/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.ColumnListHandlerGeneric;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.ListListHandlerGeneric;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;

public class Inserter {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final List<String> pk;
    private final List<Class<?>> pkTypes;
    private final DBSystemRoot sysRoot;
    private final SQLName tableName;

    private static List<Class<?>> getPKTypes(SQLTable t) {
        Set<SQLField> pk = t.getPrimaryKeys();
        ArrayList res = new ArrayList(pk.size());
        for (SQLField f : pk) {
            res.add(f.getType().getJavaType());
        }
        return res;
    }

    public Inserter(SQLTable t) {
        this(t.getDBSystemRoot(), t.getSQLName(), t.getPKsNames(), Inserter.getPKTypes(t));
    }

    public Inserter(SQLCreateTable t) {
        this(t.getRoot().getDBSystemRoot(), new SQLName(t.getRootName(), t.getName()), t.getPrimaryKey());
    }

    public Inserter(SQLCreateTableBase<?> t, DBRoot r) {
        this(r.getDBSystemRoot(), new SQLName(r.getName(), t.getName()), t.getPrimaryKey());
    }

    public Inserter(DBSystemRoot sysRoot, SQLName tableName, List<String> pk) {
        this(sysRoot, tableName, pk, null);
    }

    public Inserter(DBSystemRoot sysRoot, SQLName tableName, List<String> pk, List<Class<?>> pkTypes) {
        if (sysRoot == null || tableName == null) {
            throw new NullPointerException();
        }
        this.sysRoot = sysRoot;
        this.tableName = tableName;
        this.pk = pk;
        ArrayList arrayList = this.pkTypes = pkTypes == null ? null : new ArrayList(pkTypes);
        if (this.pkTypes != null && this.pkTypes.size() != this.pk.size()) {
            throw new IllegalArgumentException("Size mismatch");
        }
    }

    protected final SQLSystem getSystem() {
        return this.sysRoot.getServer().getSQLSystem();
    }

    public final Insertion<?> insertReturnFirstField(String sql, boolean requireAllRows) throws SQLException {
        return this.insert(sql, ReturnMode.FIRST_FIELD, requireAllRows);
    }

    public final int insertCount(String sql) throws SQLException {
        return this.insert(sql, ReturnMode.NO_FIELDS, false).getCount();
    }

    public final Insertion<?> insert(final String sql, final ReturnMode mode, final boolean requireAllRows) throws SQLException {
        boolean requireAllFields;
        final SQLSystem sys = this.getSystem();
        boolean bl = requireAllFields = mode != ReturnMode.NO_FIELDS && requireAllRows;
        if (requireAllFields && sys == SQLSystem.H2) {
            throw new IllegalArgumentException("H2 use IDENTITY() which only returns the last ID: " + this.tableName);
        }
        if (requireAllFields && sys == SQLSystem.MSSQL) {
            throw new IllegalArgumentException("In MS getUpdateCount() is correct but getGeneratedKeys() only returns the last ID: " + this.tableName);
        }
        return (Insertion)SQLUtils.executeAtomic(this.sysRoot.getDataSource(), new ConnectionHandlerNoSetup<Insertion<?>, SQLException>(){

            @Override
            public Insertion<?> handle(SQLDataSource ds) throws SQLException {
                try (Statement stmt = ds.getConnection().createStatement();){
                    Object list;
                    boolean dontGetGK;
                    String insertInto = "INSERT INTO " + Inserter.this.tableName.quote() + " " + sql;
                    boolean bl = dontGetGK = mode == ReturnMode.NO_FIELDS || Inserter.this.pk.size() == 0 || sys == SQLSystem.MYSQL && Inserter.this.pk.size() != 1;
                    int count = sys == SQLSystem.POSTGRESQL ? stmt.executeUpdate(insertInto, dontGetGK ? EMPTY_ARRAY : Inserter.this.pk.toArray(EMPTY_ARRAY)) : stmt.executeUpdate(insertInto, dontGetGK ? 2 : 1);
                    if (dontGetGK) {
                        list = null;
                    } else {
                        list = Inserter.this.pkTypes == null ? (List)(mode == ReturnMode.FIRST_FIELD ? SQLDataSource.COLUMN_LIST_HANDLER : SQLDataSource.LIST_LIST_HANDLER).handle(stmt.getGeneratedKeys()) : (mode == ReturnMode.FIRST_FIELD ? ColumnListHandlerGeneric.create(1, (Class)Inserter.this.pkTypes.get(0)).handle(stmt.getGeneratedKeys()) : ListListHandlerGeneric.create(Object.class, Inserter.this.pkTypes).handle(stmt.getGeneratedKeys()));
                        if (!$assertionsDisabled && list.size() > count) {
                            throw new AssertionError();
                        }
                        if (requireAllRows && list.size() != count) {
                            throw new IllegalStateException("Missing keys");
                        }
                    }
                    Insertion insertion = Insertion.create(list, count);
                    return insertion;
                }
            }
        });
    }

    public static final class Insertion<T> {
        private final List<T> list;
        private final int count;

        public static final <I> Insertion<I> create(List<I> res, int count) {
            return new Insertion<I>(res, count);
        }

        public Insertion(List<T> res, int count) {
            this.list = res;
            this.count = count;
            assert (res == null || res.size() <= count);
        }

        public final int getCount() {
            return this.count;
        }

        public final List<T> getRows() {
            return this.list;
        }
    }

    public static enum ReturnMode {
        NO_FIELDS,
        FIRST_FIELD,
        ALL_FIELDS;

    }
}

