/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.Tuple2;

public class SQLSelectJoin
implements SQLItem {
    private static final Tuple2<FieldRef, TableRef> NULL_TUPLE = new Tuple2<Object, Object>(null, null);
    private final SQLSelect parent;
    private final String joinType;
    private final TableRef t;
    private final Where joinW;
    private final Step step;
    private final TableRef existingTable;
    private Where where;

    SQLSelectJoin(SQLSelect parent, String joinType, TableRef existingTable, Step s, TableRef joinedTable) {
        this(parent, joinType, joinedTable, s.getFrom().getDBSystemRoot().getGraph().getWhereClause(existingTable, joinedTable, s), s, existingTable);
    }

    SQLSelectJoin(SQLSelect parent, String joinType, TableRef joinedTable, Where w, Step step, TableRef existingTable) {
        this.parent = parent;
        this.joinType = joinType;
        this.joinW = w;
        this.t = joinedTable;
        this.step = step;
        this.existingTable = existingTable;
        this.where = null;
        assert (step == null == (existingTable == null));
        assert (step == null || step.getFrom() == existingTable.getTable() && step.getTo() == joinedTable.getTable());
    }

    public final void setWhere(Where w) {
        this.where = w;
    }

    public final Where getWhere() {
        return this.where;
    }

    @Override
    public String getSQL() {
        Where archiveW = this.parent.getArchiveWhere(this.getJoinedTable().getTable(), this.getAlias());
        Where undefW = this.parent.getUndefWhere(this.getJoinedTable().getTable(), this.getAlias());
        return " " + this.joinType + " JOIN " + this.t.getSQL() + " on " + this.joinW.and(archiveW).and(undefW).and(this.getWhere());
    }

    public final Step getStep() {
        return this.step;
    }

    public final TableRef getExistingTable() {
        return this.existingTable;
    }

    public final String getAlias() {
        return this.getJoinedTable().getAlias();
    }

    public final TableRef getJoinedTable() {
        return this.t;
    }

    public String toString() {
        return this.getSQL();
    }
}

