/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Matrix;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.Closure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;

public class SQLRowValuesCluster {
    private static final Comparator<SQLField> FIELD_COMPARATOR = new Comparator<SQLField>(){

        @Override
        public int compare(SQLField o1, SQLField o2) {
            return o1.getSQLName().quote().compareTo(o2.getSQLName().quote());
        }
    };
    private final List<Link> links = new ArrayList<Link>();
    private final IdentitySet<SQLRowValues> items = new IdentityHashSet<SQLRowValues>();
    private Map<SQLRowValues, List<ValueChangeListener>> listeners = null;
    private boolean frozen = false;

    private SQLRowValuesCluster() {
    }

    SQLRowValuesCluster(SQLRowValues vals) {
        this();
        this.addVals(-1, vals);
    }

    private final void addVals(int index, SQLRowValues vals) {
        assert (vals.getGraph(false) == null);
        if (index < 0) {
            this.links.add(new Link(vals));
        } else {
            this.links.add(index, new Link(vals));
        }
        this.items.add(vals);
    }

    private final SQLRowValues getHead() {
        return this.links.get(0).getSrc();
    }

    private final DBSystemRoot getSystemRoot() {
        return this.getHead().getTable().getDBSystemRoot();
    }

    public final Set<SQLRowValues> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public final int size() {
        return this.items.size();
    }

    public final boolean contains(SQLRowValues start) {
        return this.items.contains(start);
    }

    private final void containsCheck(SQLRowValues vals) {
        if (!this.contains(vals)) {
            throw new IllegalArgumentException(vals + " not in " + this);
        }
    }

    final boolean hasOneRowPerPath() {
        for (SQLRowValues item : this.getItems()) {
            for (Map.Entry e : item.getReferents().entrySet()) {
                if (((Set)e.getValue()).size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final boolean freeze() {
        if (this.frozen) {
            return false;
        }
        this.frozen = true;
        return true;
    }

    void remove(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getGraph() == this);
        assert (src.getTable() == f.getTable());
        assert (!this.isFrozen()) : "Should already be checked by SQLRowValues";
        Link toRm = new Link(src, f, dest);
        this.links.remove(toRm);
        IdentitySet<SQLRowValues> reachable = this.getReachable(src);
        if (reachable.size() < this.size()) {
            SQLRowValuesCluster newCluster = new SQLRowValuesCluster();
            Iterator<Link> iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = iter.next();
                assert (l.getDest() == null || reachable.contains(l.getSrc()) == reachable.contains(l.getDest()));
                if (reachable.contains(l.getSrc())) continue;
                iter.remove();
                newCluster.links.add(l);
            }
            assert (newCluster.items.isEmpty());
            Iterator itemIter = this.items.iterator();
            while (itemIter.hasNext()) {
                SQLRowValues key = (SQLRowValues)itemIter.next();
                if (reachable.contains(key)) continue;
                itemIter.remove();
                newCluster.items.add(key);
                if (this.listeners == null || !this.listeners.containsKey(key)) continue;
                newCluster.getListeners().put(key, this.listeners.remove(key));
            }
            assert (!this.items.isEmpty()) : "Empty items while removing " + f + " -> " + dest + " from " + src;
            assert (!newCluster.items.isEmpty()) : "New graph is empty while removing " + f + " -> " + dest + " from " + src;
            assert (!CollectionUtils.containsAny(this.items, newCluster.items)) : "Shared items while removing " + f + " -> " + dest + " from " + src;
            for (SQLRowValues vals : newCluster.getItems()) {
                vals.setGraph(newCluster);
            }
        }
    }

    void add(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getTable() == f.getTable());
        assert (!this.isFrozen()) : "Should already be checked by SQLRowValues";
        boolean containsSrc = this.contains(src);
        boolean containsDest = this.contains(dest);
        if (!containsSrc && !containsDest) {
            throw new IllegalArgumentException("Neither source nor destination are contained in this :\n" + src + "\n" + dest);
        }
        Link toAdd = new Link(src, f, dest);
        if (containsSrc && containsDest) {
            this.links.add(toAdd);
        } else {
            int index;
            SQLRowValues rowToAdd;
            assert (src.getGraph(false) != dest.getGraph(false));
            if (containsSrc) {
                rowToAdd = dest;
                int srcIndex = this.links.indexOf(new Link(src));
                if (srcIndex < 0) {
                    throw new IllegalStateException("Source link not found for " + src);
                }
                index = srcIndex;
            } else {
                assert (containsDest);
                rowToAdd = src;
                index = -1;
            }
            SQLRowValuesCluster graphToAdd = rowToAdd.getGraph(false);
            if (graphToAdd == null) {
                this.addVals(index, rowToAdd);
                rowToAdd.setGraph(this);
            } else {
                if (index < 0) {
                    this.links.addAll(graphToAdd.links);
                } else {
                    this.links.addAll(index, graphToAdd.links);
                }
                graphToAdd.links.clear();
                this.items.addAll(graphToAdd.items);
                for (SQLRowValues newlyAdded : graphToAdd.items) {
                    newlyAdded.setGraph(this);
                }
                graphToAdd.items.clear();
                if (graphToAdd.listeners != null) {
                    this.getListeners().putAll(graphToAdd.listeners);
                    graphToAdd.listeners = null;
                }
            }
            this.links.add(toAdd);
        }
        assert (src.getGraph() == dest.getGraph());
    }

    private IdentitySet<SQLRowValues> getReachable(SQLRowValues from) {
        IdentityHashSet<SQLRowValues> res = new IdentityHashSet<SQLRowValues>();
        this.getReachableRec(from, res);
        return res;
    }

    private void getReachableRec(SQLRowValues from, IdentitySet<SQLRowValues> acc) {
        if (!acc.add(from)) {
            return;
        }
        for (SQLRowValues fVals : from.getForeigns().values()) {
            this.getReachableRec(fVals, acc);
        }
        for (SQLRowValues fVals : from.getReferentRows()) {
            this.getReachableRec(fVals, acc);
        }
    }

    final SQLRowValues deepCopy(SQLRowValues v, boolean freeze) {
        return this.deepCopy(freeze).get(v);
    }

    public final Map<SQLRowValues, SQLRowValues> deepCopy(boolean freeze) {
        IdentityHashMap<SQLRowValues, SQLRowValues> noLinkCopy = new IdentityHashMap<SQLRowValues, SQLRowValues>();
        SQLRowValues.ForeignCopyMode copyMode = SQLRowValues.ForeignCopyMode.COPY_NULL;
        for (SQLRowValues n : this.getItems()) {
            SQLRowValues copy;
            if (freeze) {
                copy = new SQLRowValues(n.getTable(), n.size(), n.getForeignsSize(), n.getReferents().size());
                copy.setAll(n.getAllValues(copyMode));
            } else {
                copy = new SQLRowValues(n, copyMode);
            }
            noLinkCopy.put(n, copy);
        }
        for (Link l : this.links) {
            if (l.getField() != null) {
                ((SQLRowValues)noLinkCopy.get(l.getSrc())).put(l.getField().getName(), noLinkCopy.get(l.getDest()));
                continue;
            }
            assert (noLinkCopy.containsKey(l.getSrc()));
        }
        SQLRowValues res = (SQLRowValues)noLinkCopy.values().iterator().next();
        if (freeze) {
            res.getGraph().freeze();
        }
        assert (res.isFrozen() == freeze);
        return noLinkCopy;
    }

    public final StoreResult store(StoreMode mode) throws SQLException {
        return this.store(mode, null);
    }

    public final StoreResult store(StoreMode mode, Boolean checkValidity) throws SQLException {
        return this.store(mode, null, null, checkValidity, true);
    }

    public final StoreResult store(final StoreMode mode, SQLRowValues start, SQLRowValues pruneGraph, Boolean checkValidity, final boolean fireEvent) throws SQLException {
        IdentityHashMap prune2orig;
        SQLRowValuesCluster toStore;
        boolean prune;
        boolean bl = prune = pruneGraph != null;
        if (!prune) {
            toStore = this;
            prune2orig = null;
        } else {
            Map<SQLRowValues, SQLRowValues> orig2prune = this.pruneMap(start, pruneGraph, true);
            toStore = orig2prune.get(start).getGraph();
            prune2orig = CollectionUtils.invertMap(new IdentityHashMap(), orig2prune);
        }
        final IdentityHashMap<SQLRowValues, Node> nodes = new IdentityHashMap<SQLRowValues, Node>(toStore.size());
        IdentityHashMap<SQLRowValues, Node> res = prune ? new IdentityHashMap<SQLRowValues, Node>(toStore.size()) : nodes;
        for (SQLRowValues vals : toStore.getItems()) {
            nodes.put(vals, new Node(vals));
            if (!prune) continue;
            SQLRowValues src = (SQLRowValues)prune2orig.get(vals);
            assert (this.contains(src));
            res.put(src, (Node)nodes.get(vals));
        }
        if (SQLRowValues.isValidityChecked(checkValidity)) {
            for (Node n : nodes.values()) {
                n.noLink.checkValidity();
            }
        }
        final ArrayList<StoringLink> storingLinks = new ArrayList<StoringLink>(toStore.links.size());
        for (Link l : toStore.links) {
            storingLinks.add(new StoringLink(l));
        }
        List<SQLTableEvent> events = SQLUtils.executeAtomic(this.getSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<List<SQLTableEvent>, SQLException>(){

            @Override
            public List<SQLTableEvent> handle(SQLDataSource ds) throws SQLException {
                ArrayList<SQLTableEvent> res = new ArrayList<SQLTableEvent>();
                while (storingLinks.size() > 0) {
                    StoringLink toStore = (StoringLink)storingLinks.remove(0);
                    if (!toStore.canStore()) {
                        throw new IllegalStateException();
                    }
                    Node n = (Node)nodes.get(toStore.getSrc());
                    boolean lastDBAccess = true;
                    Iterator iter = storingLinks.iterator();
                    while (iter.hasNext()) {
                        StoringLink sl = (StoringLink)iter.next();
                        if (sl.getSrc() != toStore.getSrc()) continue;
                        if (sl.canStore()) {
                            iter.remove();
                            if (sl.destID == null) continue;
                            n.noLink.put(sl.getField().getName(), sl.destID);
                            continue;
                        }
                        lastDBAccess = false;
                    }
                    if (n.isStored()) {
                        res.add(n.update(fireEvent));
                    } else {
                        res.add(n.store(fireEvent, mode));
                        SQLRow r = n.getStoredRow();
                        for (StoringLink sl : storingLinks) {
                            if (sl.getDest() != toStore.getSrc()) continue;
                            sl.destID = r.getIDNumber();
                            ((Node)nodes.get(sl.getSrc())).noLink.put(sl.getField().getName(), r.getIDNumber());
                        }
                    }
                    if (!lastDBAccess) continue;
                    for (Map.Entry<String, SQLRowValues> e : toStore.getSrc().getForeigns().entrySet()) {
                        SQLRowValues foreign = ((Node)nodes.get(e.getValue())).getStoredValues();
                        if (!$assertionsDisabled && foreign == null) {
                            throw new AssertionError((Object)"since this the last db access for this row, all foreigns should have been inserted");
                        }
                        if (n.getStoredValues().getLong(e.getKey()) != foreign.getIDNumber().longValue()) {
                            throw new IllegalStateException("stored " + n.getStoredValues().getObject(e.getKey()) + " but foreign is " + SQLRowValues.trim(foreign));
                        }
                        n.getStoredValues().put(e.getKey(), foreign);
                    }
                }
                SQLRowValues graphFetched = ((Node)nodes.values().iterator().next()).getStoredValues();
                if (graphFetched != null) {
                    graphFetched.getGraph().freeze();
                }
                return res;
            }
        });
        if (fireEvent) {
            for (SQLTableEvent n : events) {
                n.getTable().fire(n);
            }
        }
        return new StoreResult(res);
    }

    public final <T> void walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure) {
        this.walk(start, acc, closure, RecursionType.BREADTH_FIRST);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType) {
        return this.walk(start, acc, closure, recType, Link.Direction.FOREIGN);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType, Link.Direction foreign) {
        return this.walk(start, acc, closure, new WalkOptions(foreign).setRecursionType(recType));
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, WalkOptions options) {
        this.containsCheck(start);
        return this.walk(new State<T>(Collections.singletonList(start), Path.get(start.getTable()), acc, closure), options, options.isStartIncluded());
    }

    private final <T> StopRecurseException walk(State<T> state, WalkOptions options, boolean computeThisState) {
        StopRecurseException e;
        if (computeThisState && options.getRecursionType() == RecursionType.BREADTH_FIRST && (e = state.compute()) != null) {
            return e;
        }
        if (!options.isCycleAllowed() || !state.hasCycle()) {
            StopRecurseException res = null;
            if (options.getDirection() != Link.Direction.REFERENT) {
                res = this.rec(state, options, Link.Direction.FOREIGN);
            }
            if (res != null) {
                return res;
            }
            if (options.getDirection() != Link.Direction.FOREIGN) {
                res = this.rec(state, options, Link.Direction.REFERENT);
            }
            if (res != null) {
                return res;
            }
        }
        if (computeThisState && options.getRecursionType() == RecursionType.DEPTH_FIRST && (e = state.compute()) != null) {
            return e;
        }
        return null;
    }

    private <T> StopRecurseException rec(State<T> state, WalkOptions options, Link.Direction actualDirection) {
        SetMap<SQLField, SQLRowValues> nextVals;
        SQLRowValues current = state.getCurrent();
        List<SQLRowValues> currentValsPath = state.getValsPath();
        if (actualDirection == Link.Direction.FOREIGN) {
            Map<SQLField, SQLRowValues> foreigns = current.getForeignsBySQLField();
            nextVals = new SetMap(new LinkedHashMap(foreigns.size()), CollectionMap2.Mode.NULL_FORBIDDEN);
            nextVals.mergeScalarMap(foreigns);
        } else {
            assert (actualDirection == Link.Direction.REFERENT);
            nextVals = current.getReferents();
        }
        ArrayList keys = new ArrayList(nextVals.keySet());
        if (actualDirection == Link.Direction.REFERENT || options.isForeignsOrderIgnored()) {
            Collections.sort(keys, FIELD_COMPARATOR);
        }
        for (SQLField f : keys) {
            Step step = Step.create(f, actualDirection);
            boolean backtrack = state.getPath().length() > 0 && state.getPath().getStep(-1).equals(step.reverse());
            for (SQLRowValues v : (Set)nextVals.getNonNull(f)) {
                if (backtrack && v == state.getPrevious() || !options.isCycleAllowed() && state.identityContains(v)) continue;
                Path path = state.getPath().add(step);
                ArrayList<SQLRowValues> valsPath = new ArrayList<SQLRowValues>(currentValsPath);
                valsPath.add(v);
                StopRecurseException e = this.walk(new State<T>(Collections.unmodifiableList(valsPath), path, state.getAcc(), ((State)state).closure), options, true);
                if (e == null || !e.isCompletely()) continue;
                return e;
            }
        }
        return null;
    }

    public final IndexedRows getIndexedRows(SQLRowValues vals, RecursionType recType, boolean useForeignsOrder) {
        int size = this.size();
        final ArrayList flatList = new ArrayList(size);
        final IdentityHashMap thisIndexes = new IdentityHashMap(size);
        WalkOptions walkOptions = new WalkOptions(Link.Direction.ANY).setRecursionType(recType).setForeignsOrderIgnored(!useForeignsOrder).setStartIncluded(true);
        this.walk(vals, null, new ITransformer<State<Object>, Object>(){

            public Object transformChecked(State<Object> input) {
                SQLRowValues r = input.getCurrent();
                if (thisIndexes.containsKey(r)) {
                    throw new StopRecurseException("already added").setCompletely(false);
                }
                thisIndexes.put(r, flatList.size());
                flatList.add(input);
                return null;
            }
        }, walkOptions);
        assert (flatList.size() == size) : "missing rows, should have been " + size + " but was " + flatList.size() + " : " + flatList;
        return new IndexedRows(Collections.unmodifiableList(flatList), Collections.unmodifiableMap(thisIndexes));
    }

    private final Map<SQLRowValues, SQLRowValues> pruneMap(SQLRowValues start, SQLRowValues graph, final boolean keepUnionOfFields) {
        this.containsCheck(start);
        if (!start.getTable().equals(graph.getTable())) {
            throw new IllegalArgumentException(start + " is not from the same table as " + graph);
        }
        if (!graph.getGraph().hasOneRowPerPath()) {
            throw new IllegalArgumentException("More than one row for " + graph.printGraph());
        }
        Map<SQLRowValues, SQLRowValues> map = start.getGraph().deepCopy(false);
        final SQLRowValues res = map.get(start);
        final SetMap toRetain = new SetMap(new IdentityHashMap(), CollectionMap2.Mode.NULL_FORBIDDEN);
        WalkOptions walkOptions = new WalkOptions(Link.Direction.ANY).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(true).setCycleAllowed(true);
        graph.getGraph().walk(graph, null, new ITransformer<State<Object>, Object>(){

            public Object transformChecked(State<Object> input) {
                SQLRowValues r = input.getCurrent();
                Collection<SQLRowValues> rows = res.followPath(input.getPath(), SQLRowValues.CreateMode.CREATE_NONE, false, true);
                if (rows.isEmpty()) {
                    throw new StopRecurseException().setCompletely(false);
                }
                for (SQLRowValues row : rows) {
                    if (keepUnionOfFields || !toRetain.containsKey(row)) {
                        toRetain.addAll(row, r.getFields());
                        continue;
                    }
                    ((Set)toRetain.getCollection(row)).retainAll(r.getFields());
                }
                return null;
            }
        }, walkOptions);
        for (Map.Entry e : toRetain.entrySet()) {
            SQLRowValues r = (SQLRowValues)e.getKey();
            r.retainAll((Collection)e.getValue());
            HashSet<String> toFlatten = new HashSet<String>();
            for (Map.Entry<String, SQLRowValues> e2 : r.getForeigns().entrySet()) {
                SQLRowValues foreign = e2.getValue();
                if (toRetain.containsKey(foreign)) continue;
                toFlatten.add(e2.getKey());
            }
            for (String fieldToFlatten : toFlatten) {
                r.flatten(fieldToFlatten, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
            }
        }
        for (SQLRowValues r : new ArrayList<SQLRowValues>(res.getGraph().getItems())) {
            if (toRetain.containsKey(r)) continue;
            HashSet<String> toFlatten = new HashSet<String>();
            for (Map.Entry<String, SQLRowValues> e2 : r.getForeigns().entrySet()) {
                SQLRowValues foreign = e2.getValue();
                if (!toRetain.containsKey(foreign)) continue;
                toFlatten.add(e2.getKey());
            }
            r.removeAll(toFlatten);
        }
        assert (res.getGraph().getItems().equals(toRetain.keySet()));
        return map;
    }

    public final String printTree(SQLRowValues root, int cellLength) {
        this.containsCheck(root);
        final IdentityHashMap ys = new IdentityHashMap();
        final AtomicInteger currentY = new AtomicInteger(0);
        final Matrix<SQLRowValues> matrix = new Matrix<SQLRowValues>();
        this.walk(root, null, new Closure<State<Object>>(){

            public void executeChecked(State<Object> input) {
                SQLRowValues r = input.getCurrent();
                final int y = ys.containsKey(r) ? ((Integer)ys.get(r)).intValue() : currentY.getAndIncrement();
                matrix.put(input.getPath().length(), y, input.getCurrent());
                SQLRowValues ancestor = input.getPrevious();
                if (ancestor != null) {
                    ancestor.walkGraph(null, new Closure<State<Object>>(){

                        public void executeChecked(State<Object> input) {
                            SQLRowValues ancestorRow = input.getCurrent();
                            if (ys.containsKey(ancestorRow)) {
                                throw new StopRecurseException();
                            }
                            ys.put(ancestorRow, y);
                        }
                    });
                }
            }
        }, RecursionType.DEPTH_FIRST, Link.Direction.REFERENT);
        return matrix.print(cellLength, new ITransformer<SQLRowValues, String>(){

            public String transformChecked(SQLRowValues input) {
                if (input == null) {
                    return "";
                }
                if (input.hasID()) {
                    return input.asRow().simpleToString();
                }
                return input.getTable().toString();
            }
        });
    }

    public final String printNodes() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getSimpleName()) + " of " + this.size() + " nodes:\n");
        for (SQLRowValues n : this.getItems()) {
            StringUtils.appendFixedWidthString(sb, String.valueOf(System.identityHashCode(n)), 12, StringUtils.Side.LEFT, ' ', true);
            sb.append(' ');
            sb.append(n.getTable());
            sb.append('\t');
            for (Map.Entry<String, SQLRowValues> e : n.getForeigns().entrySet()) {
                sb.append(e.getKey());
                sb.append(" -> ");
                sb.append(System.identityHashCode(e.getValue()));
                sb.append(" ; ");
            }
            sb.append(new SQLRowValues(n, SQLRowValues.ForeignCopyMode.NO_COPY));
            sb.append("\n");
        }
        return sb.toString();
    }

    public final DiffResult getFirstDifference(SQLRowValues vals, SQLRowValues other, boolean useForeignsOrder, boolean useFieldsOrder, boolean usePK) {
        this.containsCheck(vals);
        DiffResultBuilder b = new DiffResultBuilder(vals, other);
        if (vals == other) {
            return b.build(null);
        }
        int size = this.size();
        if (size != other.getGraph().size()) {
            return b.build("different size : " + size + " != " + other.getGraph().size());
        }
        if (!vals.equalsJustThis(other, useFieldsOrder, false, usePK)) {
            return b.build("unequal :\n" + vals + " !=\n" + other);
        }
        if (size == 1) {
            return b.build(null);
        }
        IndexedRows thisRows = this.getIndexedRows(vals, RecursionType.BREADTH_FIRST, useForeignsOrder);
        IndexedRows otherRows = other.getGraph().getIndexedRows(other, RecursionType.BREADTH_FIRST, useForeignsOrder);
        b.setRows(thisRows, otherRows);
        int i = 0;
        while (i < size) {
            Path oPath;
            SQLRowValues thisVals = thisRows.getRow(i);
            SQLRowValues oVals = otherRows.getRow(i);
            Path thisPath = thisRows.getFirstPath(i);
            if (!thisPath.equals(oPath = otherRows.getFirstPath(i))) {
                return b.build("unequal graph at index " + i + " " + thisPath + " != " + oPath);
            }
            assert (i != 0 || thisVals == vals && oVals == other);
            if (i != 0 && !thisVals.equalsJustThis(oVals, useFieldsOrder, false, usePK)) {
                return b.build("unequal local values at " + thisPath + " :\n" + thisVals + " !=\n" + oVals);
            }
            Map<String, SQLRowValues> thisForeigns = thisVals.getForeigns();
            Map<String, SQLRowValues> otherForeigns = oVals.getForeigns();
            if (!thisForeigns.keySet().equals(otherForeigns.keySet())) {
                return b.build("unequal foreigns at " + thisPath + " :\n" + thisForeigns.keySet() + " !=\n" + otherForeigns.keySet());
            }
            for (Map.Entry<String, SQLRowValues> e : thisForeigns.entrySet()) {
                String ff = e.getKey();
                SQLRowValues thisForeign = e.getValue();
                SQLRowValues otherForeign = otherForeigns.get(ff);
                if (thisRows.getIndex(thisForeign) == otherRows.getIndex(otherForeign)) continue;
                return b.build("unequal foreign " + ff + " at " + thisPath + " for " + thisVals + " and " + oVals);
            }
            ++i;
        }
        return b.build(null);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.links;
    }

    private final Map<SQLRowValues, List<ValueChangeListener>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new IdentityHashMap<SQLRowValues, List<ValueChangeListener>>(4);
        }
        return this.listeners;
    }

    final void fireModification(SQLRowValues vals, String fieldName, Object newValue) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, fieldName, newValue));
        }
    }

    final void fireModification(SQLRowValues vals, Map<String, ?> m) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, m));
        }
    }

    final void fireModification(SQLRowValues vals, Set<String> removed) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, removed));
        }
    }

    private final void fireModification(ValueChangeEvent evt) {
        for (List<ValueChangeListener> list : this.listeners.values()) {
            for (ValueChangeListener l : list) {
                l.valueChange(evt);
            }
        }
    }

    final void fireModification(SQLRowValues.ReferentChangeEvent evt) {
        if (this.referentFireNeeded(evt.isAddition())) {
            for (List<ValueChangeListener> list : this.listeners.values()) {
                for (ValueChangeListener l : list) {
                    l.referentChange(evt);
                }
            }
        }
    }

    final boolean referentFireNeeded(boolean put) {
        return this.hasListeners() && !put;
    }

    final boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public static class Commit
    extends StoreMode {
        @Override
        SQLTableEvent execOn(SQLRowValues vals, boolean fetchStoredRow) throws SQLException {
            return vals.commitJustThis(fetchStoredRow);
        }
    }

    public static final class DiffResult {
        private final String firstDiff;
        private final SQLRowValues vals;
        private final SQLRowValues otherVals;
        private final IndexedRows thisRows;
        private final IndexedRows otherRows;

        private DiffResult(String firstDiff, SQLRowValues vals, SQLRowValues otherVals) {
            this.firstDiff = firstDiff;
            this.thisRows = null;
            this.otherRows = null;
            this.vals = vals;
            this.otherVals = otherVals;
        }

        private DiffResult(String firstDiff, IndexedRows thisRows, IndexedRows otherRows) {
            this.firstDiff = firstDiff;
            this.thisRows = thisRows;
            this.otherRows = otherRows;
            assert (!this.isEqual() || this.getRows1().getSize() == this.getRows2().getSize());
            this.vals = thisRows.getRow(0);
            this.otherVals = otherRows.getRow(0);
        }

        public String getFirstDifference() {
            return this.firstDiff;
        }

        public final boolean isEqual() {
            return this.getFirstDifference() == null;
        }

        public IndexedRows getRows1() {
            return this.thisRows;
        }

        public IndexedRows getRows2() {
            return this.otherRows;
        }
    }

    private static final class DiffResultBuilder {
        private final SQLRowValues vals;
        private final SQLRowValues other;
        private IndexedRows valsRows;
        private IndexedRows otherRows;

        private DiffResultBuilder(SQLRowValues vals, SQLRowValues other) {
            this.vals = vals;
            this.other = other;
        }

        private void setRows(IndexedRows thisRows, IndexedRows otherRows) {
            assert (thisRows.getRow(0) == this.vals);
            assert (otherRows.getRow(0) == this.other);
            this.valsRows = thisRows;
            this.otherRows = otherRows;
        }

        private DiffResult build(String firstDiff) {
            if (this.valsRows != null && this.otherRows != null) {
                return new DiffResult(firstDiff, this.valsRows, this.otherRows);
            }
            if (firstDiff == null) {
                return new DiffResult(firstDiff, new IndexedRows(this.vals), new IndexedRows(this.other));
            }
            return new DiffResult(firstDiff, this.vals, this.other);
        }
    }

    public static final class IndexedRows {
        private final List<State<?>> flatList;
        private final Map<SQLRowValues, Integer> indexes;

        private IndexedRows(SQLRowValues sole) {
            this(Collections.singletonList(new State<Object>(Collections.singletonList(sole), Path.get(sole.getTable()), null, null)), Collections.singletonMap(sole, 0));
            if (sole.getGraphSize() != 1) {
                throw new IllegalArgumentException("Row is not alone : " + sole.printGraph());
            }
        }

        private IndexedRows(List<State<?>> flatList, Map<SQLRowValues, Integer> indexes) {
            this.flatList = flatList;
            this.indexes = indexes;
            assert (flatList.size() == indexes.size());
        }

        public int getSize() {
            return this.flatList.size();
        }

        State<?> getFirstState(int i) {
            return this.flatList.get(i);
        }

        public SQLRowValues getRow(int i) {
            return this.getFirstState(i).getCurrent();
        }

        public Path getFirstPath(int i) {
            return this.getFirstState(i).getPath();
        }

        public int getIndex(SQLRowValues v) {
            return this.indexes.get(v);
        }
    }

    public static class Insert
    extends StoreMode {
        private final boolean insertPK;
        private final boolean insertOrder;

        public Insert(boolean insertPK, boolean insertOrder) {
            this.insertPK = insertPK;
            this.insertOrder = insertOrder;
        }

        @Override
        SQLTableEvent execOn(SQLRowValues vals, boolean fetchStoredRow) throws SQLException {
            HashSet<SQLField> autoFields = new HashSet<SQLField>();
            if (!this.insertPK) {
                autoFields.addAll(vals.getTable().getPrimaryKeys());
            }
            if (!this.insertOrder) {
                autoFields.add(vals.getTable().getOrderField());
            }
            return vals.insertJustThis(fetchStoredRow, autoFields);
        }
    }

    private static class Link {
        private final SQLRowValues src;
        private final SQLField f;
        private final SQLRowValues dest;

        public Link(SQLRowValues src) {
            this(src, null, null);
        }

        public Link(SQLRowValues src, SQLField f, SQLRowValues dest) {
            if (src == null) {
                throw new NullPointerException("src is null");
            }
            assert (f == null && dest == null || dest != null && f.getTable() == src.getTable());
            this.src = src;
            this.f = f;
            this.dest = dest;
        }

        public final SQLRowValues getSrc() {
            return this.src;
        }

        public final SQLRowValues getDest() {
            return this.dest;
        }

        public final SQLField getField() {
            return this.f;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.src);
            result = 31 * result + System.identityHashCode(this.dest);
            result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return this.src == other.src && this.dest == other.dest && CompareUtils.equals(this.f, other.f);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + System.identityHashCode(this.src) + (this.f == null ? "" : " " + this.f.getName() + " " + System.identityHashCode(this.dest));
        }
    }

    private static final class Node {
        private final SQLRowValues noLink;
        private final List<SQLTableEvent> modif = new ArrayList<SQLTableEvent>();

        private Node(SQLRowValues vals) {
            this.noLink = new SQLRowValues(vals, SQLRowValues.ForeignCopyMode.NO_COPY);
        }

        private SQLTableEvent store(boolean fetchStoredRow, StoreMode mode) throws SQLException {
            return this.store(fetchStoredRow, mode, true);
        }

        private SQLTableEvent store(boolean fetchStoredRow, StoreMode mode, boolean setRowValues) throws SQLException {
            assert (!this.isStored());
            SQLTableEvent evt = this.addEvent(mode.execOn(this.noLink, fetchStoredRow));
            if (fetchStoredRow && evt.getRow() != null && setRowValues) {
                evt.setRowValues(evt.getRow().asRowValues());
            }
            return evt;
        }

        private SQLTableEvent update(boolean fetchStoredRow) throws SQLException {
            assert (this.isStored());
            HashSet<String> fieldsToUpdate = new HashSet<String>(this.noLink.getFields());
            fieldsToUpdate.removeAll(this.getEvent().getFieldNames());
            assert (fieldsToUpdate.size() > 0);
            SQLRowValues updatingVals = this.getStoredRow().createEmptyUpdateRow();
            updatingVals.load(this.noLink, fieldsToUpdate);
            SQLTableEvent evt = new Node(updatingVals).store(fetchStoredRow, StoreMode.COMMIT, false);
            if (fetchStoredRow && evt.getRow() != null) {
                this.getStoredValues().load(evt.getRow(), null);
                evt.setRowValues(this.getStoredValues());
            }
            return this.addEvent(evt);
        }

        public final boolean isStored() {
            return this.modif.size() > 0;
        }

        public final SQLRow getStoredRow() {
            return this.getEvent() == null ? null : this.getEvent().getRow();
        }

        public final SQLRowValues getStoredValues() {
            return this.getEvent() == null ? null : this.getEvent().getRowValues();
        }

        private final SQLTableEvent getEvent() {
            return CollectionUtils.getLast(this.modif);
        }

        private final SQLTableEvent addEvent(SQLTableEvent evt) {
            if (evt == null) {
                throw new IllegalStateException("Couldn't update missing row  " + this.noLink);
            }
            this.modif.add(evt);
            return evt;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.noLink;
        }
    }

    public static final class State<T> {
        private final List<SQLRowValues> valsPath;
        private final Path path;
        private T acc;
        private final ITransformer<State<T>, T> closure;

        State(List<SQLRowValues> valsPath, Path path, T acc, ITransformer<State<T>, T> closure) {
            this.valsPath = valsPath;
            this.path = path;
            this.acc = acc;
            this.closure = closure;
        }

        public SQLField getFrom() {
            return this.path.length() == 0 ? null : this.path.getSingleField(this.path.length() - 1);
        }

        public final boolean isBackwards() {
            if (this.path.length() == 0) {
                throw new IllegalStateException("empty path");
            }
            return this.path.isBackwards(this.path.length() - 1);
        }

        StopRecurseException compute() {
            try {
                this.acc = this.closure.transformChecked(this);
                return null;
            }
            catch (StopRecurseException e) {
                return e;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " path: " + this.path + " current node: " + this.getCurrent() + " current acc: " + this.getAcc();
        }

        public final SQLRowValues getCurrent() {
            return CollectionUtils.getLast(this.valsPath);
        }

        public final SQLRowValues getPrevious() {
            return CollectionUtils.getNoExn(this.valsPath, this.valsPath.size() - 2);
        }

        public final List<SQLRowValues> getValsPath() {
            return this.valsPath;
        }

        final boolean identityContains(SQLRowValues vals) {
            return CollectionUtils.identityContains(this.valsPath, vals);
        }

        boolean hasCycle() {
            int size = this.valsPath.size();
            if (size < 2) {
                return false;
            }
            return CollectionUtils.identityContains(this.valsPath.subList(0, size - 1), this.valsPath.get(size - 1));
        }

        public Path getPath() {
            return this.path;
        }

        public T getAcc() {
            return this.acc;
        }
    }

    public static final class StopRecurseException
    extends RuntimeException {
        private boolean completely = true;

        public StopRecurseException() {
        }

        public StopRecurseException(String message) {
            super(message);
        }

        public final StopRecurseException setCompletely(boolean completely) {
            this.completely = completely;
            return this;
        }

        public final boolean isCompletely() {
            return this.completely;
        }
    }

    public static abstract class StoreMode {
        public static final StoreMode COMMIT = new Commit();
        public static final StoreMode INSERT = new Insert(false, false);
        public static final StoreMode INSERT_VERBATIM = new Insert(true, true);

        abstract SQLTableEvent execOn(SQLRowValues var1, boolean var2) throws SQLException;
    }

    public static final class StoreResult {
        private final Map<SQLRowValues, Node> nodes;

        public StoreResult(Map<SQLRowValues, Node> nodes) {
            this.nodes = nodes;
        }

        public final SQLRow getStoredRow(SQLRowValues vals) {
            return this.nodes.get(vals).getStoredRow();
        }
    }

    private static final class StoringLink
    extends Link {
        private Number destID = null;

        private StoringLink(Link l) {
            super(l.getSrc(), l.getField(), l.getDest());
        }

        public final boolean canStore() {
            return this.getDest() == null || this.destID != null;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " destID: " + this.destID;
        }
    }

    public static class ValueChangeEvent
    extends EventObject {
        private final Map<String, ?> added;
        private final Set<String> removed;

        private ValueChangeEvent(SQLRowValues vals, Map<String, ?> m) {
            super(vals);
            this.added = Collections.unmodifiableMap(m);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, String fieldName, Object newValue) {
            super(vals);
            this.added = Collections.singletonMap(fieldName, newValue);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, Set<String> removed) {
            super(vals);
            this.added = Collections.emptyMap();
            this.removed = Collections.unmodifiableSet(removed);
        }

        @Override
        public SQLRowValues getSource() {
            return (SQLRowValues)super.getSource();
        }

        public final Set<String> getAddedFields() {
            return this.added.keySet();
        }

        public final Set<String> getRemovedFields() {
            return this.removed;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " added : " + this.getAddedFields() + " removed: " + this.getRemovedFields();
        }
    }

    public static interface ValueChangeListener
    extends SQLRowValues.ReferentChangeListener {
        public void valueChange(ValueChangeEvent var1);
    }

    public static final class WalkOptions {
        private final Link.Direction direction;
        private RecursionType recType;
        private boolean allowCycle;
        private boolean includeStart;
        private boolean ignoreForeignsOrder;

        public WalkOptions(Link.Direction dir) {
            if (dir == null) {
                throw new NullPointerException("No direction");
            }
            this.direction = dir;
            this.recType = RecursionType.BREADTH_FIRST;
            this.allowCycle = false;
            this.includeStart = true;
            this.ignoreForeignsOrder = true;
        }

        public Link.Direction getDirection() {
            return this.direction;
        }

        public RecursionType getRecursionType() {
            return this.recType;
        }

        public WalkOptions setRecursionType(RecursionType recType) {
            if (recType == null) {
                throw new NullPointerException("No type");
            }
            this.recType = recType;
            return this;
        }

        public boolean isCycleAllowed() {
            return this.allowCycle;
        }

        public WalkOptions setCycleAllowed(boolean allowCycle) {
            this.allowCycle = allowCycle;
            return this;
        }

        public boolean isStartIncluded() {
            return this.includeStart;
        }

        public WalkOptions setStartIncluded(boolean includeStart) {
            this.includeStart = includeStart;
            return this;
        }

        public boolean isForeignsOrderIgnored() {
            return this.ignoreForeignsOrder;
        }

        public WalkOptions setForeignsOrderIgnored(boolean ignoreForeignsOrder) {
            this.ignoreForeignsOrder = ignoreForeignsOrder;
            return this;
        }
    }
}

