/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Clob;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.HashingStrategy;
import org.openconcerto.utils.convertor.StringClobConvertor;

public abstract class SQLRowAccessor
implements SQLData {
    private static final boolean ACCESS_DB_IF_NEEDED = Boolean.parseBoolean(System.getProperty("SQLRowAccessor.accessDBIfNeeded", "false"));
    private static final HashingStrategy<SQLRowAccessor> ROW_STRATEGY = new HashingStrategy<SQLRowAccessor>(){};
    private final SQLTable table;

    public static boolean getAccessDBIfNeeded() {
        return ACCESS_DB_IF_NEEDED;
    }

    protected SQLRowAccessor(SQLTable table) {
        if (table == null) {
            throw new NullPointerException("null SQLTable");
        }
        this.table = table;
    }

    @Override
    public final SQLTable getTable() {
        return this.table;
    }

    public final boolean hasID() throws ClassCastException {
        return this.getIDNumber() != null;
    }

    public abstract int getID();

    public abstract Number getIDNumber();

    public final boolean isUndefined() {
        Number id = this.getIDNumber();
        return id != null && id.intValue() == this.getTable().getUndefinedID();
    }

    public final boolean isArchived() {
        return this.isArchived(true);
    }

    protected final boolean isArchived(boolean allowDBAccess) {
        SQLField archiveField = this.getTable().getArchiveField();
        if (archiveField == null) {
            return false;
        }
        Object archiveVal = this.getRequiredObject(archiveField.getName(), allowDBAccess);
        if (archiveField.getType().getJavaType().equals(Boolean.class)) {
            return (Boolean)archiveVal;
        }
        return ((Number)archiveVal).intValue() > 0;
    }

    public final SQLRowValues createEmptyUpdateRow() {
        return new SQLRowValues(this.getTable()).setID(this.getIDNumber());
    }

    public abstract Set<String> getFields();

    public abstract Object getObject(String var1);

    public final Object getContainedObject(String fieldName) throws IllegalArgumentException {
        return this.getObject(fieldName, true);
    }

    protected final Object getRequiredObject(String fieldName, boolean allowDBAccess) throws IllegalArgumentException {
        return this.getObject(fieldName, this instanceof SQLRowValues || !allowDBAccess);
    }

    public final Object getObject(String fieldName, boolean mustBePresent) throws IllegalArgumentException {
        if (mustBePresent && !this.getFields().contains(fieldName)) {
            throw new IllegalArgumentException("Field " + fieldName + " not present in this : " + this.getFields() + " table " + this.getTable().getName());
        }
        return this.getObject(fieldName);
    }

    public abstract Map<String, Object> getAbsolutelyAll();

    public final String getString(String field) {
        String result = null;
        Object obj = this.getObject(field);
        if (obj == null) {
            result = null;
        } else if (obj instanceof Date) {
            DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
            result = df.format((Date)obj);
        } else if (obj instanceof Clob) {
            try {
                result = (String)StringClobConvertor.INSTANCE.unconvert((Clob)obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = obj.toString();
            }
        } else {
            result = obj.toString();
        }
        return result;
    }

    public final int getInt(String field) {
        return this.getObjectAs(field, Number.class).intValue();
    }

    public final long getLong(String field) {
        return this.getObjectAs(field, Number.class).longValue();
    }

    public final Boolean getBoolean(String field) {
        return this.getObjectAs(field, Boolean.class);
    }

    public final <T> T getObjectAs(String field, Class<T> clazz) {
        T res = null;
        try {
            res = clazz.cast(this.getObject(field));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Impossible d'acc\u00e9der au champ " + field + " de la ligne " + this + " en tant que " + clazz.getSimpleName(), e);
        }
        return res;
    }

    protected final SQLTable getForeignTable(String fieldName) throws IllegalArgumentException {
        return (SQLTable)this.getForeignLink(Collections.singletonList(fieldName)).getTarget();
    }

    protected final Link getForeignLink(List<String> fieldsNames) throws IllegalArgumentException {
        DatabaseGraph graph = this.getTable().getDBSystemRoot().getGraph();
        Link foreignLink = graph.getForeignLink(this.getTable(), fieldsNames);
        if (foreignLink == null) {
            throw new IllegalArgumentException(fieldsNames + " are not a foreign key of " + this.getTable());
        }
        return foreignLink;
    }

    public final Value<Number> getForeignIDNumberValue(String fieldName) throws IllegalArgumentException {
        this.fetchIfNeeded(fieldName);
        Object val = this.getContainedObject(fieldName);
        if (val instanceof SQLRowValues) {
            SQLRowValues vals = (SQLRowValues)val;
            return vals.hasID() ? Value.getSome(vals.getIDNumber()) : Value.getNone();
        }
        if (!this.getTable().getField(fieldName).isForeignKey()) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + "is not a foreign key of " + this.getTable());
        }
        return Value.getSome((Number)val);
    }

    private void fetchIfNeeded(String fieldName) {
        if (SQLRowAccessor.getAccessDBIfNeeded() && this instanceof SQLRow && !this.getFields().contains(fieldName)) {
            assert (false) : "Missing " + fieldName + " in " + this;
            Log.get().log(Level.WARNING, "Missing " + fieldName + " in " + this, new IllegalStateException());
            ((SQLRow)this).fetchValues();
        }
    }

    public final boolean isForeignEmpty(String fieldName) {
        Value<Number> fID = this.getForeignIDNumberValue(fieldName);
        if (!fID.hasValue()) {
            return false;
        }
        SQLTable foreignTable = this.getForeignTable(fieldName);
        Number undefID = foreignTable.getUndefinedIDNumber();
        return NumberUtils.areNumericallyEqual(fID.getValue(), undefID);
    }

    public final boolean equalsAsRow(SQLRowAccessor o) {
        return this.getTable() == o.getTable() && this.getID() == o.getID();
    }

    public final int hashCodeAsRow() {
        return this.getTable().hashCode() + this.getID();
    }
}

