/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;

public class SQLRow
extends SQLRowAccessor {
    private final int ID;
    private final Number idNumber;
    private Map<String, Object> values;
    private boolean fetched = false;
    private static final SQLTable.VirtualFields ALL_VALUES_FIELDS = SQLTable.VirtualFields.ALL.difference(SQLTable.VirtualFields.KEYS, SQLTable.VirtualFields.ARCHIVE, SQLTable.VirtualFields.ORDER);

    private static final List<String> getFieldNames(SQLTable table, ResultSetMetaData rsmd, boolean tableOnly) throws SQLException {
        int colCount = rsmd.getColumnCount();
        ArrayList<String> names = new ArrayList<String>(colCount);
        int i = 1;
        while (i <= colCount) {
            if (tableOnly || rsmd.getTableName(i).equals(table.getName())) {
                names.add(rsmd.getColumnName(i));
            } else {
                names.add(null);
            }
            ++i;
        }
        return names;
    }

    static final SQLRow createFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        int indexCount = names.size();
        HashMap<String, Object> m = new HashMap<String, Object>(indexCount);
        int i = 0;
        while (i < indexCount) {
            String colName = names.get(i);
            if (colName != null) {
                m.put(colName, rs.getObject(i + 1));
            }
            ++i;
        }
        Number id = SQLRow.getID(m, table, true);
        if (id == null) {
            return null;
        }
        return new SQLRow(table, id, m);
    }

    public static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, boolean tableOnly) throws SQLException {
        return SQLRow.createListFromRS(table, rs, SQLRow.getFieldNames(table, rs.getMetaData(), tableOnly));
    }

    static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        ArrayList<SQLRow> res = new ArrayList<SQLRow>();
        while (rs.next()) {
            SQLRow row = SQLRow.createFromRS(table, rs, names);
            if (row == null) continue;
            res.add(row);
        }
        return res;
    }

    static final SQLRow createFromSelect(SQLTable t, SQLTable.VirtualFields vfs, int id, SQLSelect.LockStrength l) {
        SQLSelect sel = new SQLSelect(true).addAllSelect(t.getFields(vfs));
        sel.setLockStrength(l);
        sel.setWhere(new Where((FieldRef)t.getKey(), "=", id));
        Map map = (Map)t.getDBSystemRoot().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.MAP_HANDLER, l.equals((Object)SQLSelect.LockStrength.NONE)));
        return new SQLRow(t, id, map);
    }

    static final SQLRow createEmpty(SQLTable t, int id) {
        return new SQLRow(t, id, Collections.emptyMap());
    }

    private SQLRow(SQLTable table, Number id) {
        super(table);
        this.ID = id.intValue();
        this.idNumber = id;
        this.checkTable();
    }

    public SQLRow(SQLTable table, int ID) {
        this(table, table.getKey().getType().getJavaType() == Integer.class ? (Number)ID : (Number)Long.valueOf(ID));
    }

    private void checkTable() {
        if (!this.getTable().isRowable()) {
            throw new IllegalArgumentException(this.getTable() + " is not rowable");
        }
    }

    public SQLRow(SQLTable table, Map<String, ?> values) {
        this(table, null, values);
    }

    private SQLRow(SQLTable table, Number id, Map<String, ?> values) {
        this(table, id == null ? (Number)SQLRow.getID(values, table, false) : (Number)id);
        this.setValues(values == null ? null : new HashMap(values));
    }

    private static Number getID(Map<String, ?> values, SQLTable table, boolean nullAllowed) {
        String keyName = table.getKey().getName();
        if (!values.containsKey(keyName)) {
            throw new IllegalArgumentException(values + " does not contain the key of " + table);
        }
        Object keyValue = values.get(keyName);
        if (keyValue instanceof Number) {
            return (Number)keyValue;
        }
        if (nullAllowed && keyValue == null) {
            return null;
        }
        String valS = keyValue == null ? "' is null" : "' isn't a Number : " + keyValue.getClass() + " " + keyValue;
        throw new IllegalArgumentException("The value of '" + keyName + valS);
    }

    public final boolean isFilled() {
        return this.fetched;
    }

    private Map<String, Object> getValues() {
        if (!this.isFilled()) {
            this.fetchValues();
        }
        return this.values;
    }

    public final void fetchValues() {
        this.fetchValues(true);
    }

    public final SQLRow fetchValues(boolean useCache) {
        return this.fetchValues(useCache, useCache);
    }

    SQLRow fetchValues(boolean readCache, boolean writeCache) {
        IResultSetHandler handler = new IResultSetHandler(SQLDataSource.MAP_HANDLER, readCache, writeCache){

            public Set<SQLRow> getCacheModifiers() {
                return Collections.singleton(SQLRow.this);
            }
        };
        this.setValues((Map)this.getTable().getBase().getDataSource().execute(this.getQuery(), (ResultSetHandler)handler, false));
        return this;
    }

    private final void setValues(Map<String, Object> values) {
        this.values = values;
        if (!this.fetched) {
            this.fetched = true;
        }
    }

    @Override
    public Set<String> getFields() {
        return this.fetched ? Collections.unmodifiableSet(this.getValues().keySet()) : Collections.emptySet();
    }

    private String getQuery() {
        return "SELECT * FROM " + this.getTable().getSQLName().quote() + " WHERE " + this.getWhere().getClause();
    }

    public Where getWhere() {
        return new Where((FieldRef)this.getTable().getKey(), "=", this.getID());
    }

    public boolean exists() {
        return this.getValues() != null;
    }

    public boolean isValid() {
        return this.exists() && this.getID() >= 0 && !this.isArchived();
    }

    @Override
    public final Object getObject(String field) {
        if (!this.exists()) {
            throw new IllegalStateException("The row " + this + "does not exist.");
        }
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("The table of the row " + this + " doesn't contain the field '" + field + "'.");
        }
        if (!this.getValues().containsKey(field)) {
            this.fetchValues();
            String msg = "The row " + this.simpleToString() + " doesn't contain the field '" + field + "' ; refetching.";
            Log.get().warning(msg);
        }
        assert (this.getValues().containsKey(field));
        return this.getValues().get(field);
    }

    public String toString() {
        return this.fullToString(false);
    }

    public String fullToString(boolean allowDBAccess) {
        Boolean exists;
        String res = this.simpleToString();
        Boolean bl = exists = allowDBAccess || this.isFilled() ? Boolean.valueOf(this.exists()) : null;
        if (exists == null) {
            res = "?" + res + "?";
        } else if (!exists.booleanValue()) {
            res = "-" + res + "-";
        } else {
            Boolean archived;
            block9: {
                archived = null;
                try {
                    archived = this.isArchived(allowDBAccess);
                }
                catch (Exception e) {
                    Log.get().log(Level.FINER, "Couldn't determine archive status", e);
                    if ($assertionsDisabled || archived == null) break block9;
                    throw new AssertionError();
                }
            }
            if (archived == null) {
                res = "?" + res + "?";
            } else if (archived.booleanValue()) {
                res = "(" + res + ")";
            }
        }
        return res;
    }

    public String simpleToString() {
        return String.valueOf(this.getTable().getName()) + "[" + this.ID + "]";
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return Collections.unmodifiableMap(this.getValues());
    }

    public SQLRowValues createUpdateRow() {
        return new SQLRowValues(this.getTable(), this.getValues());
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public Number getIDNumber() {
        return this.idNumber;
    }

    public final SQLRowValues asRowValues() {
        return this.createUpdateRow();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SQLRow)) {
            return false;
        }
        SQLRow o = (SQLRow)other;
        return this.equalsAsRow(o);
    }

    public int hashCode() {
        return this.hashCodeAsRow();
    }

    public static List<String> toList(String path) {
        return Arrays.asList(SQLRow.toArray(path));
    }

    private static String[] toArray(String path) {
        if (path.length() == 0) {
            return new String[0];
        }
        return path.split(",");
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRow>(this, l);
    }
}

