/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.openconcerto.sql.Log;
import org.openconcerto.utils.ExceptionUtils;

public class SQLRequestLog {
    private static final Color BG_PINK = new Color(254, 240, 240);
    private static Vector<SQLRequestLog> list = new Vector(500);
    private static boolean enabled;
    private String query;
    private String comment;
    private long startAsMs;
    private final long startTime;
    private final long afterCache;
    private final long afterQueryInfo;
    private final long afterExecute;
    private final long afterHandle;
    private final long endTime;
    private String stack;
    private boolean inSwing;
    private int connectionId;
    private boolean forShare;
    private String threadId;
    private static List<ChangeListener> listeners;
    private static JLabel textInfo;
    private static final DateFormat sdt;
    private static final DecimalFormat dformat;
    private boolean isHighlighted = false;
    private int rs_count;
    static long total_count;

    static {
        listeners = new ArrayList<ChangeListener>(2);
        sdt = new SimpleDateFormat("HH:mm:ss.SS");
        dformat = new DecimalFormat("##0.00");
        total_count = 0L;
    }

    public SQLRequestLog(String query, String comment, int connectionId, long starAtMs, String ex, boolean inSwing, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        this.query = query;
        this.comment = comment;
        this.connectionId = connectionId;
        this.startAsMs = starAtMs;
        this.startTime = startTime;
        this.afterCache = afterCache;
        this.afterQueryInfo = afterQueryInfo;
        this.afterExecute = afterExecute;
        this.afterHandle = afterHandle;
        this.endTime = endTime;
        this.rs_count = count;
        this.stack = ex;
        this.inSwing = inSwing;
        this.forShare = query.contains("FOR SHARE");
        if (this.forShare) {
            this.comment = "Use FOR SHARE. " + comment;
        }
        this.threadId = "[" + Thread.currentThread().getId() + "] " + Thread.currentThread().getName();
    }

    public static void log(String query, String comment, int connectionId, long starAtMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        if (enabled && list.size() < 50000) {
            String ex = ExceptionUtils.getStackTrace(new Exception());
            list.add(new SQLRequestLog(query, comment, connectionId, starAtMs, ex, SwingUtilities.isEventDispatchThread(), startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, count));
            SQLRequestLog.fireEvent();
        }
        ++count;
    }

    public static void log(String query, String comment, long starAtMs, long startTime) {
        SQLRequestLog.log(query, comment, 0, starAtMs, startTime, startTime, startTime, startTime, startTime, startTime, 0);
    }

    public static void log(PreparedStatement pStmt, String comment, long timeMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime) {
        if (enabled) {
            try {
                SQLRequestLog.log(pStmt.toString(), comment, pStmt.getConnection(), timeMs, startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, 0);
            }
            catch (Exception e) {
                Log.get().log(Level.WARNING, "Couldn't log " + pStmt, e);
            }
        }
    }

    public static void log(String query, String comment, Connection conn, long timeMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        SQLRequestLog.log(query, comment, System.identityHashCode(conn), timeMs, startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, count);
    }

    private static void fireEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int stop = listeners.size();
                int i = 0;
                while (i < stop) {
                    ((ChangeListener)listeners.get(i)).stateChanged(null);
                    ++i;
                }
                long totalMs = SQLRequestLog.getTotalMs();
                long totalSQLMs = SQLRequestLog.getTotalSQLMs();
                textInfo.setText("Total: " + totalMs + " ms,  Swing: " + SQLRequestLog.getTotalSwing() + " ms, SQL: " + totalSQLMs + " ms, processing: " + (totalMs - totalSQLMs) + " ms , " + SQLRequestLog.getNbConnections() + " conn., " + SQLRequestLog.getNbThread() + " threads. Total: " + list.size() + " / " + total_count);
            }
        });
    }

    protected static int getNbConnections() {
        HashSet<Integer> s = new HashSet<Integer>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            if (l.getConnectionId() > 0) {
                s.add(l.getConnectionId());
            }
            ++i;
        }
        return s.size();
    }

    protected static int getNbThread() {
        HashSet<String> s = new HashSet<String>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            s.add(l.getThreadId());
            ++i;
        }
        return s.size();
    }

    protected static long getTotalMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += list.get(i).getDurationTotalNano() / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSQLMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += list.get(i).getDurationSQLNano() / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSwing() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            SQLRequestLog requestLog = list.get(i);
            if (requestLog.isInSwing()) {
                t += requestLog.getDurationTotalNano() / 1000L;
            }
            ++i;
        }
        return t / 1000L;
    }

    public boolean isInSwing() {
        return this.inSwing;
    }

    public long getDurationTotalNano() {
        return this.getEndTime() - this.getStartTime();
    }

    public long getDurationSQLNano() {
        return this.getAfterExecute() - this.getAfterQueryInfo();
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getAfterQueryInfo() {
        return this.afterQueryInfo;
    }

    public final long getAfterExecute() {
        return this.afterExecute;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getThreadId() {
        return this.threadId;
    }
}

