/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;

public final class DBRoot
extends DBStructureItemDB {
    DBRoot(DBStructureItemJDBC delegate) {
        super(delegate);
    }

    public final SQLBase getBase() {
        return this.getJDBC().getAncestor(SQLBase.class);
    }

    public SQLTable getTable(String name) {
        return (SQLTable)DBRoot.getJDBC(this.getChild(name));
    }

    public SQLTable findTable(String name) {
        return this.findTable(name, false);
    }

    public SQLTable findTable(String name, boolean mustExist) {
        SQLTable res = this.getTable(name);
        if (res != null) {
            return res;
        }
        return this.getDBSystemRoot().findTable(name, mustExist);
    }

    public Set<SQLTable> getTables() {
        return this.getJDBC().getDescendants(SQLTable.class);
    }

    public final void createTables(SQLCreateTableBase<?> ... createTables) throws SQLException {
        this.createTables(Arrays.asList(createTables));
    }

    public final void createTables(Collection<? extends SQLCreateTableBase<?>> createTables) throws SQLException {
        this.createTables(CollectionUtils.fillMap(new HashMap(), createTables), false);
    }

    private final void createTables(final Map<? extends SQLCreateTableBase<?>, ? extends Map<String, ?>> undefinedNonDefaultValues, final boolean atLeast1UndefRow) throws SQLException {
        int size = undefinedNonDefaultValues.size();
        if (size == 0) {
            return;
        }
        final HashSet<String> tableNames = new HashSet<String>(size);
        for (SQLCreateTableBase<?> ct : undefinedNonDefaultValues.keySet()) {
            tableNames.add(ct.getName());
        }
        SQLUtils.executeAtomic(this.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                SQLCreateTableBase createTable;
                HashMap<SQLTable, SQLCreateTableBase> newTables;
                Map<SQLCreateTableBase, Number> newUndefIDs;
                List<List<String>> createTablesSQL = ChangeTable.cat(undefinedNonDefaultValues.keySet(), DBRoot.this.getName(), EnumSet.of(ChangeTable.ConcatStep.ADD_CONSTRAINT));
                for (String sql : createTablesSQL.get(0)) {
                    ds.execute(sql);
                }
                if (atLeast1UndefRow) {
                    newUndefIDs = new HashMap();
                    newTables = new HashMap<SQLTable, SQLCreateTableBase>();
                    DBRoot.this.refetch(tableNames);
                } else {
                    newUndefIDs = Collections.emptyMap();
                    newTables = null;
                }
                for (Map.Entry e : undefinedNonDefaultValues.entrySet()) {
                    createTable = (SQLCreateTableBase)e.getKey();
                    String tableName = createTable.getName();
                    Map m = (Map)e.getValue();
                    if (m == null) {
                        SQLTable.setUndefID(DBRoot.this.getSchema(), tableName, null);
                        continue;
                    }
                    SQLTable t = DBRoot.this.getTable(tableName);
                    newUndefIDs.put(createTable, null);
                    newTables.put(t, createTable);
                    if (!t.isRowable()) continue;
                    SQLRowValues vals = new SQLRowValues(t, m);
                    if (t.isOrdered()) {
                        vals.put(t.getOrderField().getName(), ReOrder.MIN_ORDER);
                    }
                    for (SQLField f : t.getContentFields()) {
                        Object o;
                        if (vals.getFields().contains(f.getName()) || f.isNullable() == Boolean.TRUE || f.getDefaultValue() != null) continue;
                        Class<?> javaType = f.getType().getJavaType();
                        if (String.class.isAssignableFrom(javaType)) {
                            o = "";
                        } else if (Number.class.isAssignableFrom(javaType)) {
                            o = 0;
                        } else if (Boolean.class.isAssignableFrom(javaType)) {
                            o = Boolean.FALSE;
                        } else if (Date.class.isAssignableFrom(javaType)) {
                            o = new Date(0L);
                        } else {
                            throw new UnsupportedOperationException("cannot find value for " + f.getSQLName());
                        }
                        vals.put(f.getName(), o);
                    }
                    SQLRow undefRow = vals.getGraph().store(new SQLRowValuesCluster.Insert(false, true), false).getStoredRow(vals);
                    SQLTable.setUndefID(DBRoot.this.getSchema(), tableName, undefRow.getID());
                    newUndefIDs.put(createTable, undefRow.getIDNumber());
                }
                for (Map.Entry e : newUndefIDs.entrySet()) {
                    UpdateBuilder update;
                    createTable = (SQLCreateTableBase)e.getKey();
                    SQLTable t = DBRoot.this.getTable(createTable.getName());
                    Number undefID = (Number)e.getValue();
                    if (undefID != null) {
                        update = new UpdateBuilder(t);
                        update.setWhere(new Where((FieldRef)t.getKey(), "=", (Object)undefID));
                    } else {
                        update = null;
                    }
                    AlterTable alterTable = new AlterTable(t);
                    for (ChangeTable.FCSpec fc : createTable.getForeignConstraints()) {
                        SQLTable targetT;
                        Number foreignUndefID;
                        if (fc.getCols().size() != 1 || (foreignUndefID = (Number)newUndefIDs.get(newTables.get(targetT = t.getDescLenient(fc.getRefTable(), SQLTable.class)))) == null) continue;
                        String ffName = fc.getCols().get(0);
                        String foreignUndefIDSQL = t.getField(ffName).getType().toString(foreignUndefID);
                        alterTable.alterColumnDefault(ffName, foreignUndefIDSQL);
                        update.set(ffName, foreignUndefIDSQL);
                    }
                    if (update != null && !update.isEmpty()) {
                        ds.execute(update.asString());
                    }
                    if (alterTable.isEmpty()) continue;
                    ds.execute(alterTable.asString());
                }
                for (String sql : createTablesSQL.get(1)) {
                    ds.execute(sql);
                }
                DBRoot.this.getSchema().updateVersion();
                return null;
            }
        });
        this.refetch(tableNames);
    }

    public final String getMetadata(String name) {
        return this.getSchema().getFwkMetadata(name);
    }

    public final SQLSchema getSchema() {
        return (SQLSchema)this.getJDBC().getNonNullDBParent();
    }

    public void refetch() throws SQLException {
        this.refetch(null);
    }

    public SQLTable refetchTable(String tableName) throws SQLException {
        if (tableName == null) {
            throw new NullPointerException("Null table");
        }
        return this.getSchema().fetchTable(tableName);
    }

    public void refetch(Set<String> tableNames) throws SQLException {
        this.getBase().fetchTables(TablesMap.createFromTables(this.getSchema().getName(), tableNames));
    }
}

