/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.JDOMException;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementNames;
import org.openconcerto.sql.element.SQLElementNamesFromXML;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.TranslationManager;

public final class SQLElementDirectory {
    public static final String BASENAME = SQLElementNames.class.getSimpleName();
    private static final LocalizedInstances<SQLElementNames> LOCALIZED_INSTANCES = new LocalizedInstances<SQLElementNames>(SQLElementNames.class, TranslationManager.getControl()){

        @Override
        protected SQLElementNames createInstance(String bundleName, Locale candidate, Class<?> cl) throws IOException {
            InputStream ins = cl.getResourceAsStream(String.valueOf('/') + this.getControl().toResourceName(bundleName, "xml"));
            if (ins == null) {
                return null;
            }
            SQLElementNamesFromXML res = new SQLElementNamesFromXML(candidate);
            try {
                try {
                    res.load(ins);
                }
                catch (JDOMException e) {
                    throw new IOException("Invalid XML", e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            finally {
                ins.close();
            }
            return res;
        }
    };
    private final Map<SQLTable, SQLElement> elements = new HashMap<SQLTable, SQLElement>();
    private final SetMap<String, SQLTable> tableNames = new SetMap();
    private final SetMap<String, SQLTable> byCode = new SetMap();
    private final SetMap<Class<? extends SQLElement>, SQLTable> byClass = new SetMap();
    private final List listeners = new ArrayList();
    private String phrasesPkgName = null;
    private final Map<String, SQLElementNames> elementNames = new HashMap<String, SQLElementNames>();
    private final ShowAs showAs = new ShowAs(null);

    public final synchronized void destroy() {
        for (SQLElement elem : this.elements.values()) {
            elem.destroy();
        }
    }
}

