/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;

public abstract class Configuration {
    private static Configuration instance;
    private ExecutorService nonInteractiveSQLExecutor;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static synchronized Configuration getInstance() {
        return instance;
    }

    public static final void migrateToNewDir(File oldDir, File newDir) throws IOException {
        if (oldDir.exists() && !newDir.exists()) {
            if (!oldDir.isDirectory()) {
                throw new IOException("Old file isn't a directory : " + oldDir);
            }
            FileUtils.mkdir_p(newDir.getParentFile());
            String err = FileUtils.mv(oldDir, newDir);
            if (err != null) {
                throw new IOException("Couldn't migrate from " + oldDir + " : " + err);
            }
        }
    }

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (StringUtils.isEmpty(appName)) {
            return null;
        }
        String variant = this.getAppVariant();
        if (StringUtils.isEmpty(variant, true)) {
            return appName;
        }
        return String.valueOf(appName) + '-' + variant;
    }

    public String getAppVariant() {
        return null;
    }

    public abstract BaseDirs getBaseDirs();

    @Deprecated
    protected File getOldConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.nonInteractiveSQLExecutor != null) {
                this.nonInteractiveSQLExecutor.shutdown();
            }
        }
    }
}

