/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.erp.modules.DepLink;
import org.openconcerto.erp.modules.ModuleFactory;

class DependencyGraph
extends DirectedMultigraph<ModuleFactory, DepLink> {
    private final Set<String> ids = new HashSet<String>();

    public DependencyGraph() {
        super(DepLink.class);
    }

    @Override
    public boolean addVertex(ModuleFactory v) {
        String id = v.getID();
        if (this.ids.contains(id)) {
            throw new IllegalStateException("ID already exists : " + v);
        }
        boolean res = super.addVertex(v);
        this.ids.add(id);
        return res;
    }

    @Override
    public boolean removeVertex(ModuleFactory v) {
        boolean res = super.removeVertex(v);
        this.ids.remove(v.getID());
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vertexSet().hashCode();
        result = 31 * result + this.edgeSet().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyGraph other = (DependencyGraph)obj;
        return this.vertexSet().equals(other.vertexSet()) && this.edgeSet().equals(other.edgeSet());
    }
}

