/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;

public class BarcodeReader
implements KeyEventDispatcher {
    public int maxInterKeyDelay;
    private final List<BarcodeListener> listeners;
    private String value;
    private final List<KeyEvent> eve;
    private long firstTime;
    private Timer timer;
    private TimerTask task;
    private boolean enable;

    private void fire(String code) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).barcodeRead(code);
            ++i;
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.enable) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        long t = e.getWhen();
        if (this.firstTime < 0L) {
            this.firstTime = t;
        }
        int key = e.getKeyCode();
        long delay = t - this.firstTime;
        if (key == 8 || key == 127 || delay > (long)this.maxInterKeyDelay && key != 16) {
            this.eve.add(e);
            this.redispatch();
            return true;
        }
        char key2 = e.getKeyChar();
        this.eve.add(e);
        if (e.getID() == 402) {
            if (key != 16) {
                if (key2 == '*' || key2 == '$' || key2 == '+' || key2 == '/' || key2 == '%' || key2 == '-' | key2 == ' ') {
                    this.value = String.valueOf(this.value) + key2;
                } else if (Character.isLetter(key2) || Character.isDigit(key2)) {
                    this.value = String.valueOf(this.value) + key2;
                } else if (key >= 48 && key <= 57 || key >= 65 && key <= 90) {
                    this.value = String.valueOf(this.value) + (char)key;
                } else if (key == 10 && this.value.length() >= 2) {
                    this.value = this.value.trim();
                    this.fire(this.value);
                    this.reset();
                } else {
                    this.redispatch();
                }
            }
            if (!this.eve.isEmpty()) {
                this.firstTime = t;
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        BarcodeReader.this.redispatchLater();
                    }
                };
                this.timer.schedule(this.task, this.maxInterKeyDelay);
            }
            assert (!this.eve.isEmpty() || this.firstTime == -1L);
        }
        return true;
    }

    private void redispatchLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarcodeReader.this.redispatch();
            }
        });
    }

    private void redispatch() {
        int i = 0;
        while (i < this.eve.size()) {
            KeyEvent ee = this.eve.get(i);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(ee.getComponent(), ee);
            int j = 0;
            while (j < this.listeners.size()) {
                this.listeners.get(j).keyReceived(ee);
                ++j;
            }
            ++i;
        }
        this.reset();
    }

    private void reset() {
        this.value = "";
        this.eve.clear();
        this.firstTime = -1L;
    }
}

