/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.ExceptionHandler;

public class POSConfiguration {
    private static POSConfiguration instance;
    private final File confFile;
    private int screenWidth;
    private int screenHeight;
    private TicketPrinterConfiguration ticketPrinterConf1;
    private TicketPrinterConfiguration ticketPrinterConf2;
    private int userID = 2;
    private int companyID = 42;
    private int posID = 2;
    private int scanDelay = 80;
    private List<TicketLine> headerLines = new ArrayList<TicketLine>();
    private List<TicketLine> footerLines = new ArrayList<TicketLine>();
    private String creditCardPort = "";
    private String LCDType = "serial";
    private String LCDPort = "";
    private String LCDLine1 = "Bienvenue";
    private String LCDLine2 = "ILM Informatique";
    private SQLRow rowClient = null;

    public static synchronized POSConfiguration getInstance() {
        if (instance == null) {
            instance = new POSConfiguration(POSConfiguration.getConfigFile(new File(".")));
            instance.loadConfiguration();
        }
        return instance;
    }

    private POSConfiguration(File confFile) {
        this.confFile = confFile;
        this.ticketPrinterConf1 = new TicketPrinterConfiguration();
        this.ticketPrinterConf2 = new TicketPrinterConfiguration();
        this.ticketPrinterConf2.setCopyCount(0);
    }

    public TicketPrinterConfiguration getTicketPrinterConfiguration1() {
        return this.ticketPrinterConf1;
    }

    public TicketPrinterConfiguration getTicketPrinterConfiguration2() {
        return this.ticketPrinterConf2;
    }

    public boolean isConfigurationFileCreated() {
        File file = this.getConfigFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public int getUserID() {
        return this.userID;
    }

    public void setUserID(int userID) {
        this.userID = userID;
    }

    public int getCompanyID() {
        return this.companyID;
    }

    public void setCompanyID(int companyID) {
        this.companyID = companyID;
    }

    public int getPosID() {
        return this.posID;
    }

    public void setPosID(int posID) {
        this.posID = posID;
    }

    public void setScanDelay(int ms) {
        this.scanDelay = ms;
    }

    public String getCreditCardPort() {
        return this.creditCardPort;
    }

    public void setCreditCardPort(String creditCardPort) {
        this.creditCardPort = creditCardPort;
    }

    private static File getConfigFile(File wd) {
        File confFile;
        File wdFile = new File(wd + "/Configuration", "pos.xml");
        if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            try {
                File preferencesFolder = BaseDirs.create(ComptaPropsConfiguration.productInfo).getPreferencesFolderToWrite();
                confFile = new File(preferencesFolder, "pos.xml");
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't get folder", e);
            }
        }
        return confFile;
    }

    public final File getConfigFile() {
        return this.confFile;
    }

    public List<TicketLine> getHeaderLines() {
        return this.headerLines;
    }

    public void setHeaderLines(List<TicketLine> headerLines) {
        this.headerLines = headerLines;
    }

    public List<TicketLine> getFooterLines() {
        return this.footerLines;
    }

    public void setFooterLines(List<TicketLine> footerLines) {
        this.footerLines = footerLines;
    }

    private void loadConfiguration() {
        if (!this.isConfigurationFileCreated()) {
            System.err.println("POSConfiguration.loadConfigurationFromXML() configuration not loaded. " + this.getConfigFile().getAbsolutePath() + " missing.");
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        File file = this.getConfigFile();
        try {
            List<Element> printers;
            List<Element> footers;
            List<Element> headers;
            List<Element> childrenLCD;
            List<Element> childrenCreditCard;
            System.out.println("POSConfiguration.loadConfigurationFromXML() loading " + file.getAbsolutePath());
            Document document = builder.build(file);
            Element rootElement = document.getRootElement();
            this.setUserID(Integer.valueOf(rootElement.getAttributeValue("userID", "2")));
            this.setCompanyID(Integer.valueOf(rootElement.getAttributeValue("societeID", "42")));
            this.setPosID(Integer.valueOf(rootElement.getAttributeValue("caisseID", "2")));
            this.setScanDelay(Integer.valueOf(rootElement.getAttributeValue("scanDelay", "80")));
            List<Element> children = rootElement.getChildren("screen");
            if (children != null) {
                for (Element e : children) {
                    this.screenWidth = Integer.valueOf(e.getAttributeValue("width", "0"));
                    this.screenHeight = Integer.valueOf(e.getAttributeValue("height", "0"));
                }
            }
            if ((childrenCreditCard = rootElement.getChildren("creditcard")) != null) {
                for (Element e : childrenCreditCard) {
                    this.creditCardPort = e.getAttributeValue("port", "");
                }
            }
            if ((childrenLCD = rootElement.getChildren("lcd")) != null) {
                for (Element e : childrenLCD) {
                    this.LCDType = e.getAttributeValue("type", "serial");
                    this.LCDPort = e.getAttributeValue("port", "");
                    this.LCDLine1 = e.getAttributeValue("line1", "");
                    this.LCDLine2 = e.getAttributeValue("line2", "");
                }
            }
            if ((headers = rootElement.getChildren("header")) != null) {
                for (Element header : headers) {
                    this.headerLines.add(new TicketLine(header.getValue(), header.getAttributeValue("style")));
                }
            }
            if ((footers = rootElement.getChildren("footer")) != null) {
                for (Element header : footers) {
                    this.footerLines.add(new TicketLine(header.getValue(), header.getAttributeValue("style")));
                }
            }
            if ((printers = rootElement.getChildren("ticketPrinter")).size() > 0) {
                this.configureTicketPrinter(this.ticketPrinterConf1, printers.get(0));
            }
            if (printers.size() > 1) {
                this.configureTicketPrinter(this.ticketPrinterConf2, printers.get(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureTicketPrinter(TicketPrinterConfiguration conf, Element element) {
        conf.setType(element.getAttributeValue("type"));
        conf.setName(element.getAttributeValue("name"));
        conf.setCopyCount(Integer.parseInt(element.getAttributeValue("copyCount")));
        conf.setTicketWidth(Integer.parseInt(element.getAttributeValue("ticketWidth")));
        conf.setFolder(element.getAttributeValue("folder", ""));
    }

    private Element getElementFromConfiguration(TicketPrinterConfiguration conf) {
        Element element = new Element("ticketPrinter");
        element.setAttribute("type", conf.getType());
        element.setAttribute("name", conf.getName());
        element.setAttribute("copyCount", String.valueOf(conf.getCopyCount()));
        element.setAttribute("ticketWidth", String.valueOf(conf.getTicketWidth()));
        element.setAttribute("folder", conf.getFolder());
        return element;
    }

    public void saveConfiguration() {
        File file = this.getConfigFile();
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Impossible d'enregistrer le fichier : " + file.getAbsolutePath() + "\nMerci d'accorder les droits d'\u00e9criture \u00e0 ce fichier.");
            return;
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            String style;
            Element e;
            System.out.println("Saving:" + file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Document doc = new Document();
            Element configElement = new Element("config");
            configElement.setAttribute("userID", String.valueOf(this.userID));
            configElement.setAttribute("societeID", String.valueOf(this.companyID));
            configElement.setAttribute("caisseID", String.valueOf(this.posID));
            configElement.setAttribute("scanDelay", String.valueOf(this.scanDelay));
            doc.addContent(configElement);
            Element screenElement = new Element("screen");
            screenElement.setAttribute("width", String.valueOf(this.screenWidth));
            screenElement.setAttribute("height", String.valueOf(this.screenHeight));
            configElement.addContent(screenElement);
            Element creditCardElement = new Element("creditcard");
            creditCardElement.setAttribute("port", this.creditCardPort);
            configElement.addContent(creditCardElement);
            Element lcdElement = new Element("lcd");
            lcdElement.setAttribute("type", this.LCDType);
            lcdElement.setAttribute("port", this.LCDPort);
            lcdElement.setAttribute("line1", this.LCDLine1);
            lcdElement.setAttribute("line2", this.LCDLine2);
            configElement.addContent(lcdElement);
            for (TicketLine line : this.headerLines) {
                e = new Element("header");
                style = line.getStyle();
                if (style != null && !style.isEmpty()) {
                    e.setAttribute("style", style);
                }
                e.setText(line.getText());
                configElement.addContent(e);
            }
            for (TicketLine line : this.footerLines) {
                e = new Element("footer");
                style = line.getStyle();
                if (style != null && !style.isEmpty()) {
                    e.setAttribute("style", style);
                }
                e.setText(line.getText());
                configElement.addContent(e);
            }
            configElement.addContent(this.getElementFromConfiguration(this.ticketPrinterConf1));
            configElement.addContent(this.getElementFromConfiguration(this.ticketPrinterConf2));
            outputter.output(doc, fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Erreur lors de la sauvegarde de la configuration de la caisse.\n" + file.getAbsolutePath());
        }
    }

    public String getLCDPort() {
        return this.LCDPort;
    }

    public void setLCDPort(String port) {
        this.LCDPort = port;
    }

    public String getLCDLine1() {
        return this.LCDLine1;
    }

    public void setLCDLine1(String text) {
        this.LCDLine1 = text;
    }

    public String getLCDLine2() {
        return this.LCDLine2;
    }

    public void setLCDLine2(String text) {
        this.LCDLine2 = text;
    }

    public void setLCDType(String type) {
        this.LCDType = type;
    }

    public String getLCDType() {
        return this.LCDType;
    }
}

