/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SynchronizedVerifier {
    private static volatile boolean enabled;
    private static final Map<Class<?>, AtomicBoolean> DETECT;
    private static final Map<Object, Object> CURRENT;

    public static void check(Object object) {
        if (enabled) {
            SynchronizedVerifier.detectConcurrentAccess(object);
        }
    }

    private static void detectConcurrentAccess(Object object) {
        AtomicBoolean atomicBoolean = DETECT.get(object.getClass());
        if (atomicBoolean != null) {
            atomicBoolean.set(true);
            if (CURRENT.remove(object) != null) {
                throw new AssertionError((Object)"Concurrent access");
            }
            CURRENT.put(object, object);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object object2 = CURRENT.remove(object);
            if (object2 == null) {
                throw new AssertionError((Object)"Concurrent access");
            }
        }
    }

    static {
        DETECT = Collections.synchronizedMap(new HashMap());
        CURRENT = Collections.synchronizedMap(new IdentityHashMap());
    }
}

