/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.util.Tool;

public class Server
extends Tool
implements Runnable,
ShutdownHandler {
    private final Service service;
    private boolean started;

    public Server() {
        this.service = null;
    }

    public Server(Service service, String ... stringArray) throws SQLException {
        this.verifyArgs(stringArray);
        this.service = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private void verifyArgs(String ... stringArray) throws SQLException {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || "-?".equals(string) || "-help".equals(string)) continue;
            if (string.startsWith("-web")) {
                if ("-web".equals(string) || "-webAllowOthers".equals(string) || "-webDaemon".equals(string) || "-webSSL".equals(string)) continue;
                if ("-webPort".equals(string)) {
                    ++i;
                    continue;
                }
                this.throwUnsupportedOption(string);
                continue;
            }
            if ("-browser".equals(string)) continue;
            if (string.startsWith("-tcp")) {
                if ("-tcp".equals(string) || "-tcpAllowOthers".equals(string) || "-tcpDaemon".equals(string) || "-tcpSSL".equals(string)) continue;
                if ("-tcpPort".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-tcpPassword".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-tcpShutdown".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-tcpShutdownForce".equals(string)) continue;
                this.throwUnsupportedOption(string);
                continue;
            }
            if (string.startsWith("-pg")) {
                if ("-pg".equals(string) || "-pgAllowOthers".equals(string) || "-pgDaemon".equals(string)) continue;
                if ("-pgPort".equals(string)) {
                    ++i;
                    continue;
                }
                this.throwUnsupportedOption(string);
                continue;
            }
            if (string.startsWith("-ftp")) {
                if ("-ftpPort".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-ftpDir".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-ftpRead".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-ftpWrite".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-ftpWritePassword".equals(string)) {
                    ++i;
                    continue;
                }
                if ("-ftpTask".equals(string)) continue;
                this.throwUnsupportedOption(string);
                continue;
            }
            if ("-properties".equals(string)) {
                ++i;
                continue;
            }
            if ("-trace".equals(string) || "-ifExists".equals(string)) continue;
            if ("-baseDir".equals(string)) {
                ++i;
                continue;
            }
            if ("-key".equals(string)) {
                i += 2;
                continue;
            }
            if ("-tool".equals(string)) continue;
            this.throwUnsupportedOption(string);
        }
    }

    public static Server createTcpServer(String ... stringArray) throws SQLException {
        TcpServer tcpServer = new TcpServer();
        Server server = new Server(tcpServer, stringArray);
        tcpServer.setShutdownHandler(server);
        return server;
    }

    public Server start() throws SQLException {
        try {
            this.started = true;
            this.service.start();
            String string = this.service.getName() + " (" + this.service.getURL() + ")";
            Thread thread = new Thread((Runnable)this, string);
            thread.setDaemon(this.service.isDaemon());
            thread.start();
            for (int i = 1; i < 64; i += i) {
                Server.wait(i);
                if (!this.isRunning(false)) continue;
                return this;
            }
            if (this.isRunning(true)) {
                return this;
            }
            throw DbException.get(90061, string, "timeout; please check your network configuration, specially the file /etc/hosts");
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private static void wait(int n) {
        try {
            long l = (long)n * (long)n;
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRunning(boolean bl) {
        return this.service.isRunning(bl);
    }

    public void stop() {
        this.started = false;
        if (this.service != null) {
            this.service.stop();
        }
    }

    public int getPort() {
        return this.service.getPort();
    }

    @Override
    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }
}

