/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class SelectUnion
extends Query {
    private int unionType;
    private final Query left;
    private Query right;
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private ArrayList<SelectOrderBy> orderList;
    private SortOrder sort;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    public void setUnionType(int n) {
        this.unionType = n;
    }

    public int getUnionType() {
        return this.unionType;
    }

    public void setRight(Query query) {
        this.right = query;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    private Value[] convert(Value[] valueArray, int n) {
        Value[] valueArray2 = n == valueArray.length ? valueArray : new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions.get(i);
            valueArray2[i] = valueArray[i].convertTo(expression.getType());
        }
        return valueArray2;
    }

    @Override
    public ResultInterface queryMeta() {
        int n = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n = this.left.getColumnCount();
        return new LocalResult(this.session, this.expressionArray, n);
    }

    @Override
    protected LocalResult queryWithoutCache(int n, ResultTarget resultTarget) {
        Object object;
        int n2;
        Object object2;
        if (n != 0) {
            n2 = this.limitExpr == null ? -1 : ((object2 = this.limitExpr.getValue(this.session)) == ValueNull.INSTANCE ? -1 : ((Value)object2).getInt());
            n2 = n2 < 0 ? n : Math.min(n2, n);
            this.limitExpr = ValueExpression.get(ValueInt.get(n2));
        }
        if (this.session.getDatabase().getSettings().optimizeInsertFromSelect && this.unionType == 1 && resultTarget != null && this.sort == null && !this.distinct && n == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.left.query(0, resultTarget);
            this.right.query(0, resultTarget);
            return null;
        }
        n2 = this.left.getColumnCount();
        object2 = new LocalResult(this.session, this.expressionArray, n2);
        if (this.sort != null) {
            ((LocalResult)object2).setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            ((LocalResult)object2).setDistinct();
        }
        if (this.randomAccessResult) {
            ((LocalResult)object2).setRandomAccess();
        }
        switch (this.unionType) {
            case 0: 
            case 2: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                ((LocalResult)object2).setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        LocalResult localResult = this.left.query(0);
        LocalResult localResult2 = this.right.query(0);
        localResult.reset();
        localResult2.reset();
        switch (this.unionType) {
            case 0: 
            case 1: {
                while (localResult.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult.currentRow(), n2));
                }
                while (localResult2.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult2.currentRow(), n2));
                }
                break;
            }
            case 2: {
                while (localResult.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult.currentRow(), n2));
                }
                while (localResult2.next()) {
                    ((LocalResult)object2).removeDistinct(this.convert(localResult2.currentRow(), n2));
                }
                break;
            }
            case 3: {
                object = new LocalResult(this.session, this.expressionArray, n2);
                ((LocalResult)object).setDistinct();
                ((LocalResult)object).setRandomAccess();
                while (localResult.next()) {
                    ((LocalResult)object).addRow(this.convert(localResult.currentRow(), n2));
                }
                while (localResult2.next()) {
                    Value[] valueArray = this.convert(localResult2.currentRow(), n2);
                    if (!((LocalResult)object).containsDistinct(valueArray)) continue;
                    ((LocalResult)object2).addRow(valueArray);
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        if (this.offsetExpr != null) {
            ((LocalResult)object2).setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            ((LocalResult)object2).setLimit(((Value)object).getInt());
        }
        ((LocalResult)object2).done();
        if (resultTarget != null) {
            while (((LocalResult)object2).next()) {
                resultTarget.addRow(((LocalResult)object2).currentRow());
            }
            ((LocalResult)object2).close();
            return null;
        }
        return object2;
    }

    @Override
    public void init() {
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = New.arrayList();
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            this.expressions.add(expression);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = New.arrayList();
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            Expression expression2 = arrayList2.get(i);
            int n2 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n3 = Math.max(expression.getScale(), expression2.getScale());
            int n4 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            Column column = new Column(expression.getAlias(), n2, l, n3, n4);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case 0: 
            case 1: 
            case 3: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case 2: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL()).append(')');
        switch (this.unionType) {
            case 1: {
                stringBuilder.append("\nUNION ALL\n");
                break;
            }
            case 0: {
                stringBuilder.append("\nUNION\n");
                break;
            }
            case 3: {
                stringBuilder.append("\nINTERSECT\n");
                break;
            }
            case 2: {
                stringBuilder.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL()).append(')');
        Expression[] expressionArray = this.expressions.toArray(new Expression[this.expressions.size()]);
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, expressionArray.length));
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                stringBuilder.append("\nOFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ").append(StringUtils.unEnclose(this.sampleSizeExpr.getSQL()));
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public LocalResult query(int n, ResultTarget resultTarget) {
        return this.queryWithoutCache(n, resultTarget);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }
}

