/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntryOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

class MagicMimeEntry {
    private ArrayList subEntries = new ArrayList();
    private int checkBytesFrom;
    private int type;
    private String typeStr;
    private String content;
    private long contentNumber;
    private MimeType mimeType;
    private String mimeEnc;
    private MagicMimeEntry parent;
    private MagicMimeEntryOperation operation = MagicMimeEntryOperation.EQUALS;

    public MagicMimeEntry(ArrayList entries) throws InvalidMagicMimeEntryException {
        this(0, null, entries);
    }

    private MagicMimeEntry(int level, MagicMimeEntry parent, ArrayList entries) throws InvalidMagicMimeEntryException {
        if (entries == null || entries.size() == 0) {
            return;
        }
        this.parent = parent;
        if (parent != null) {
            parent.subEntries.add(this);
        }
        try {
            this.addEntry((String)entries.get(0));
        }
        catch (Exception e) {
            throw new InvalidMagicMimeEntryException(entries, (Throwable)e);
        }
        entries.remove(0);
        while (entries.size() > 0) {
            int thisLevel = this.howManyGreaterThans((String)entries.get(0));
            if (thisLevel <= level) break;
            new MagicMimeEntry(thisLevel, this, entries);
        }
    }

    public String toString() {
        return "MimeMagicType: " + this.checkBytesFrom + ", " + this.type + ", " + this.content + ", " + this.mimeType + ", " + this.mimeEnc;
    }

    private int howManyGreaterThans(String aLine) {
        if (aLine == null) {
            return -1;
        }
        int i = 0;
        int len = aLine.length();
        while (i < len) {
            if (aLine.charAt(i) != '>') break;
            ++i;
        }
        return i;
    }

    void addEntry(String aLine) throws InvalidMagicMimeEntryException {
        String trimmed = aLine.replaceAll("[\\\\][ ]", "<##>").replaceAll("^>*", "").replaceAll("\\s+", "\t").replaceAll("[\t]{2,}", "\t").replaceAll("<##>", "\\\\ ");
        String[] tokens = trimmed.split("\t");
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < tokens.length) {
            if (!"".equals(tokens[i])) {
                v.add(tokens[i]);
            }
            ++i;
        }
        tokens = new String[v.size()];
        if ((tokens = v.toArray(tokens)).length > 0) {
            String tok = tokens[0].trim();
            try {
                this.checkBytesFrom = tok.startsWith("0x") ? Integer.parseInt(tok.substring(2), 16) : Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                throw new InvalidMagicMimeEntryException(Collections.singletonList(this), (Throwable)e);
            }
        }
        if (tokens.length > 1) {
            this.typeStr = tokens[1].trim();
            this.type = this.getType(this.typeStr);
        }
        if (tokens.length > 2) {
            this.content = this.ltrim(tokens[2]);
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.operation = MagicMimeEntryOperation.getOperationForNumberField(this.content);
                    break;
                }
                default: {
                    this.operation = MagicMimeEntryOperation.getOperationForStringField(this.content);
                }
            }
            if (this.content.length() > 0 && this.content.charAt(0) == this.operation.getOperationID()) {
                this.content = this.content.substring(1);
            }
            this.content = MagicMimeEntry.stringWithEscapeSubstitutions(this.content);
        } else {
            this.content = "";
        }
        if (tokens.length > 3) {
            this.mimeType = new MimeType(tokens[3].trim());
        }
        if (tokens.length > 4) {
            this.mimeEnc = tokens[4].trim();
        }
        this.initContentNumber();
    }

    private void initContentNumber() {
        this.contentNumber = 0L;
        if (this.content.length() == 0) {
            return;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.contentNumber = this.content.startsWith("0x") ? Long.parseLong(this.content.substring(2).trim(), 16) : (this.content.startsWith("0") ? Long.parseLong(this.content.trim(), 8) : Long.parseLong(this.content.trim()));
            }
        }
    }

    private String ltrim(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                return s.substring(i);
            }
            ++i;
        }
        return s;
    }

    private int getType(String tok) {
        if (tok.startsWith("string")) {
            return 1;
        }
        if (tok.startsWith("belong")) {
            return 2;
        }
        if (tok.equals("short")) {
            return 3;
        }
        if (tok.startsWith("lelong")) {
            return 4;
        }
        if (tok.startsWith("beshort")) {
            return 5;
        }
        if (tok.startsWith("leshort")) {
            return 6;
        }
        if (tok.equals("byte")) {
            return 7;
        }
        return 20;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    private static String stringWithEscapeSubstitutions(String s) {
        StringBuffer ret = new StringBuffer();
        int len = s.length();
        int indx = 0;
        while (indx < len) {
            char c = s.charAt(indx);
            if (c == '\n') break;
            if (c == '\\') {
                if (++indx >= len) {
                    ret.append(c);
                    break;
                }
                char cn = s.charAt(indx);
                if (cn == '\\') {
                    ret.append('\\');
                } else if (cn == ' ') {
                    ret.append(' ');
                } else if (cn == 't') {
                    ret.append('\t');
                } else if (cn == 'n') {
                    ret.append('\n');
                } else if (cn == 'r') {
                    ret.append('\r');
                } else if (cn == 'x') {
                    int hexEncodedValue;
                    if ((indx += 2) >= len) {
                        ret.append(c);
                        ret.append(cn);
                        break;
                    }
                    String hexDigits = s.substring(indx - 1, indx + 1);
                    try {
                        hexEncodedValue = Integer.parseInt(hexDigits, 16);
                    }
                    catch (NumberFormatException x) {
                        ret.append(c);
                        ret.append(hexDigits);
                        break;
                    }
                    ret.append((char)hexEncodedValue);
                } else if (cn >= '0' && cn <= '7') {
                    int escape = cn - 48;
                    if (++indx >= len) {
                        ret.append((char)escape);
                        break;
                    }
                    cn = s.charAt(indx);
                    if (cn >= '0' && cn <= '7') {
                        escape <<= 3;
                        escape |= cn - 48;
                        if (++indx >= len) {
                            ret.append((char)escape);
                            break;
                        }
                        cn = s.charAt(indx);
                        if (cn >= '0' && cn <= '7') {
                            escape <<= 3;
                            escape |= cn - 48;
                        } else {
                            --indx;
                        }
                    } else {
                        --indx;
                    }
                    ret.append((char)escape);
                } else {
                    ret.append(cn);
                }
            } else {
                ret.append(c);
            }
            ++indx;
        }
        return new String(ret);
    }
}

