/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeDetectorRegistry;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class MimeUtil2 {
    private static Logger log = Logger.getLogger(MimeUtil2.class.getName());
    public static final MimeType DIRECTORY_MIME_TYPE = new MimeType("application/directory");
    public static final MimeType UNKNOWN_MIME_TYPE = new MimeType("application/octet-stream");
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    private static Map mimeTypes = Collections.synchronizedMap(new HashMap());
    private static ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
    private MimeDetectorRegistry mimeDetectorRegistry = new MimeDetectorRegistry();

    public static void addKnownMimeType(MimeType mimeType) {
        MimeUtil2.addKnownMimeType(mimeType.toString());
    }

    public static void addKnownMimeType(String mimeType) {
        try {
            String key = MimeUtil2.getMediaType(mimeType);
            TreeSet<String> s = (TreeSet<String>)mimeTypes.get(key);
            if (s == null) {
                s = new TreeSet<String>();
            }
            s.add(MimeUtil2.getSubType(mimeType));
            mimeTypes.put(key, s);
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public MimeDetector registerMimeDetector(String mimeDetector) {
        return this.mimeDetectorRegistry.registerMimeDetector(mimeDetector);
    }

    public static String getMediaType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getMediaType();
    }

    public static String getSubType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getSubType();
    }
}

