/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.math;

import java.io.Serializable;

public final class MathContext
implements Serializable {
    int digits;
    int form;
    boolean lostDigits;
    int roundingMode;
    private static final int[] ROUNDS = new int[]{4, 7, 2, 1, 3, 5, 6, 0};
    private static final String[] ROUNDWORDS = new String[]{"ROUND_HALF_UP", "ROUND_UNNECESSARY", "ROUND_CEILING", "ROUND_DOWN", "ROUND_FLOOR", "ROUND_HALF_DOWN", "ROUND_HALF_EVEN", "ROUND_UP"};
    public static final MathContext DEFAULT = new MathContext(9, 1, false, 4);

    public MathContext(int setdigits, int setform) {
        this(setdigits, setform, false, 4);
    }

    public MathContext(int setdigits, int setform, boolean setlostdigits, int setroundingmode) {
        if (setdigits != 9) {
            if (setdigits < 0) {
                throw new IllegalArgumentException("Digits too small: " + setdigits);
            }
            if (setdigits > 999999999) {
                throw new IllegalArgumentException("Digits too large: " + setdigits);
            }
        }
        if (setform != 1 && setform != 2 && setform != 0) {
            throw new IllegalArgumentException("Bad form value: " + setform);
        }
        if (!MathContext.isValidRound(setroundingmode)) {
            throw new IllegalArgumentException("Bad roundingMode value: " + setroundingmode);
        }
        this.digits = setdigits;
        this.form = setform;
        this.lostDigits = setlostdigits;
        this.roundingMode = setroundingmode;
    }

    public String toString() {
        String formstr = null;
        int r = 0;
        String roundword = null;
        formstr = this.form == 1 ? "SCIENTIFIC" : (this.form == 2 ? "ENGINEERING" : "PLAIN");
        int $1 = ROUNDS.length;
        r = 0;
        while ($1 > 0) {
            if (this.roundingMode == ROUNDS[r]) {
                roundword = ROUNDWORDS[r];
                break;
            }
            --$1;
            ++r;
        }
        return "digits=" + this.digits + " " + "form=" + formstr + " " + "lostDigits=" + (this.lostDigits ? "1" : "0") + " " + "roundingMode=" + roundword;
    }

    private static boolean isValidRound(int testround) {
        int r = 0;
        int $2 = ROUNDS.length;
        r = 0;
        while ($2 > 0) {
            if (testround == ROUNDS[r]) {
                return true;
            }
            --$2;
            ++r;
        }
        return false;
    }
}

