/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.IOException;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utility {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final boolean arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(byte[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof byte[])) {
            return false;
        }
        byte[] targ = (byte[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((double[])source, target);
        }
        if (source instanceof byte[]) {
            return Utility.arrayEquals((byte[])source, target);
        }
        return source.equals(target);
    }

    public static final boolean arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (Utility.arrayEquals(source[i], target[i + delta])) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(byte[] source, int sourceStart, byte[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean objectEquals(Object a, Object b) {
        return a == null ? b == null : (b == null ? false : a.equals(b));
    }

    public static final String escape(String s) {
        int c;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(c)) {
            c = Character.codePointAt(s, i);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            buf.append(Utility.hex(c, four ? 4 : 8));
        }
        return buf.toString();
    }

    public static int unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        boolean braces = false;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = Character.codePointAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                if (offset < length && UTF16.charAt(s, offset) == 123) {
                    ++offset;
                    braces = true;
                    maxDig = 8;
                    break;
                }
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig && (dig = UCharacter.digit(c = UTF16.charAt(s, offset), bitsPerDigit == 3 ? 8 : 16)) >= 0) {
                result = result << bitsPerDigit | dig;
                offset += UTF16.getCharCount(c);
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            if (braces) {
                if (c != 125) {
                    return -1;
                }
                ++offset;
            }
            if (result < 0 || result >= 0x110000) {
                return -1;
            }
            if (offset < length && UTF16.isLeadSurrogate((char)result)) {
                int ahead = offset + 1;
                c = s.charAt(offset);
                if (c == 92 && ahead < length) {
                    int[] o = new int[]{ahead};
                    c = Utility.unescapeAt(s, o);
                    ahead = o[0];
                }
                if (UTF16.isTrailSurrogate((char)c)) {
                    offset = ahead;
                    result = Character.toCodePoint((char)result, (char)c);
                }
            }
            offset16[0] = offset;
            return result;
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
        }
        if (c == 99 && offset < length) {
            c = UTF16.charAt(s, offset);
            offset16[0] = offset + UTF16.getCharCount(c);
            return 0x1F & c;
        }
        offset16[0] = offset;
        return c;
    }

    public static String hex(long i, int places) {
        String result;
        boolean negative;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if ((result = Long.toString(i, 16).toUpperCase(Locale.ENGLISH)).length() < places) {
            result = "0000000000000000".substring(result.length(), places) + result;
        }
        if (negative) {
            return '-' + result;
        }
        return result;
    }

    public static boolean isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    public static <T extends Appendable> boolean escapeUnprintable(T result, int c) {
        try {
            if (Utility.isUnprintable(c)) {
                result.append('\\');
                if ((c & 0xFFFF0000) != 0) {
                    result.append('U');
                    result.append(DIGITS[0xF & c >> 28]);
                    result.append(DIGITS[0xF & c >> 24]);
                    result.append(DIGITS[0xF & c >> 20]);
                    result.append(DIGITS[0xF & c >> 16]);
                } else {
                    result.append('u');
                }
                result.append(DIGITS[0xF & c >> 12]);
                result.append(DIGITS[0xF & c >> 8]);
                result.append(DIGITS[0xF & c >> 4]);
                result.append(DIGITS[0xF & c]);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }
}

