/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUCache;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V>
implements ICUCache<K, V> {
    private volatile Reference<Map<K, V>> cacheRef = null;
    private int type = 0;
    private int capacity = 16;

    @Override
    public V get(Object key) {
        Map<K, V> map;
        Reference<Map<K, V>> ref = this.cacheRef;
        if (ref != null && (map = ref.get()) != null) {
            return map.get(key);
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        Reference ref = this.cacheRef;
        Map<K, V> map = null;
        if (ref != null) {
            map = ref.get();
        }
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap(this.capacity));
            ref = this.type == 1 ? new WeakReference<Map<K, V>>(map) : new SoftReference<Map<K, V>>(map);
            this.cacheRef = ref;
        }
        map.put(key, value);
    }
}

