/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.PFilterIterator;
import org.jdom.Parent;
import org.jdom.filter.Filter;
import org.openconcerto.utils.cc.IPredicate;

public class DescendantIterator
implements Iterator<Content> {
    private final Filter filter;
    private Iterator<?> iterator;
    private Iterator<?> nextIterator;
    private List<Iterator<?>> stack = new ArrayList();

    public DescendantIterator(Parent parent) {
        this(parent, (Filter)null);
    }

    public DescendantIterator(Parent parent, IPredicate<? super Content> pred) {
        this(parent, DescendantIterator.createFilter(pred));
    }

    private static Filter createFilter(final IPredicate<? super Content> pred) {
        return new Filter(){

            @Override
            public boolean matches(Object obj) {
                return pred.evaluateChecked((Content)obj);
            }
        };
    }

    public DescendantIterator(Parent parent, Filter filter) {
        this((List<Content>)parent.getContent(), filter);
    }

    public DescendantIterator(List<Content> content) {
        this(content, (Filter)null);
    }

    public DescendantIterator(List<Content> content, IPredicate<? super Content> pred) {
        this(content, DescendantIterator.createFilter(pred));
    }

    public DescendantIterator(List<Content> content, Filter filter) {
        if (content == null) {
            throw new IllegalArgumentException("content parameter was null");
        }
        this.filter = filter;
        this.iterator = this.wrapIter(content.iterator());
    }

    private Iterator<?> wrapIter(Iterator<?> iter) {
        if (this.filter == null) {
            return iter;
        }
        return new PFilterIterator(iter, this.filter);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator != null && this.iterator.hasNext()) {
            return true;
        }
        if (this.nextIterator != null && this.nextIterator.hasNext()) {
            return true;
        }
        return this.stackHasAnyNext();
    }

    @Override
    public Content next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextIterator != null) {
            this.push(this.iterator);
            this.iterator = this.nextIterator;
            this.nextIterator = null;
        }
        while (!this.iterator.hasNext()) {
            if (this.stack.size() > 0) {
                this.iterator = this.pop();
                continue;
            }
            throw new NoSuchElementException("Somehow we lost our iterator");
        }
        Content child = (Content)this.iterator.next();
        if (child instanceof Element) {
            this.nextIterator = this.wrapIter(((Element)child).getContent().iterator());
        }
        return child;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private Iterator<?> pop() {
        int stackSize = this.stack.size();
        if (stackSize == 0) {
            throw new NoSuchElementException("empty stack");
        }
        return this.stack.remove(stackSize - 1);
    }

    private void push(Iterator<?> itr) {
        this.stack.add(itr);
    }

    private boolean stackHasAnyNext() {
        int size = this.stack.size();
        int i = 0;
        while (i < size) {
            Iterator<?> itr = this.stack.get(i);
            if (itr.hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

