/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.StringCodec;
import org.openconcerto.utils.cc.IClosure;

public class CorrectFNameEncoding {
    public static void main(String[] args) throws CharacterCodingException {
        File root = new File(".");
        CorrectFNameEncoding.mergeTree(root);
    }

    private static void mergeTree(File root) {
        FileUtils.walk(root, new IClosure<File>(){

            private void exec(File wd, String cmd) throws IOException, InterruptedException {
                Process mv = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd}, null, wd);
                System.out.println("[exec] in " + wd + " : " + cmd);
                BufferedReader err = new BufferedReader(new InputStreamReader(mv.getErrorStream()));
                if (mv.waitFor() != 0) {
                    String errL;
                    String errors = "";
                    while ((errL = err.readLine()) != null) {
                        errors = String.valueOf(errors) + errL + "\n";
                    }
                    System.out.println(errors);
                    throw new IOException(errors);
                }
            }

            @Override
            public void executeChecked(File input) {
                if (input.isDirectory()) {
                    try {
                        String encodedName;
                        Process p = Runtime.getRuntime().exec(new String[]{"ls", "-b1"}, null, input);
                        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((encodedName = r.readLine()) != null) {
                            if (!StringCodec.isEncoded(encodedName)) continue;
                            String validName = StringCodec.decode(encodedName);
                            File validFile = new File(input, validName);
                            String invalidBashName = StringCodec.encodedToBash(encodedName);
                            if (!validFile.exists()) {
                                this.exec(input, "mv -- " + invalidBashName + " " + StringCodec.quote(validName));
                                continue;
                            }
                            if (validFile.isDirectory()) {
                                this.exec(input, "rsync -a -- " + invalidBashName + "/ " + StringCodec.quote(validName) + " && rm -rf -- " + invalidBashName);
                                continue;
                            }
                            this.exec(input, "rm -f -- " + invalidBashName);
                        }
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.createExn(IllegalStateException.class, "", e);
                    }
                }
            }
        }, RecursionType.BREADTH_FIRST);
    }
}

