/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.i18n.I18nUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TranslationManager {
    private static final Locale FALLBACK_LOCALE = Locale.ENGLISH;
    private static final ResourceBundle.Control CONTROL = new I18nUtils.SameLanguageControl(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (!locale.equals(FALLBACK_LOCALE)) {
                return FALLBACK_LOCALE;
            }
            return null;
        }
    };
    private static final String BASENAME = "translation";
    private static final TranslationManager instance = new TranslationManager();
    private final List<Class<?>> classes;
    private Locale locale;
    private final Object trMutex = new String("translations mutex");
    private Map<String, String> menuTranslation;
    private Map<String, String> itemTranslation;
    private Map<String, String> actionTranslation;

    public static final ResourceBundle.Control getControl() {
        return CONTROL;
    }

    public static final TranslationManager getInstance() {
        return instance;
    }

    private TranslationManager() {
        this.classes = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTranslationStreamFromClass(Class<?> c) {
        List<Class<?>> list = this.classes;
        synchronized (list) {
            this.classes.add(c);
            if (this.getLocale() != null) {
                this.loadTranslation(this.getLocale(), c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTranslationStreamFromClass(Class<?> c) {
        List<Class<?>> list = this.classes;
        synchronized (list) {
            if (this.classes.remove(c) && this.getLocale() != null) {
                this.loadAllTranslation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Locale getLocale() {
        List<Class<?>> list = this.classes;
        synchronized (list) {
            return this.locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLocale(Locale l) {
        if (l == null) {
            throw new NullPointerException("null Locale");
        }
        List<Class<?>> list = this.classes;
        synchronized (list) {
            if (!l.equals(this.locale)) {
                this.locale = l;
                this.loadAllTranslation();
            }
        }
    }

    private void checkNulls(String id, String label) {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (label == null) {
            throw new NullPointerException("null label");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForMenu(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.menuTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForMenu(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.menuTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForItem(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.itemTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForItem(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.itemTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForAction(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.actionTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForAction(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.actionTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllTranslation() {
        Object object = this.trMutex;
        synchronized (object) {
            this.menuTranslation = new HashMap<String, String>();
            this.itemTranslation = new HashMap<String, String>();
            this.actionTranslation = new HashMap<String, String>();
            if (this.classes.size() == 0) {
                Log.get().warning("TranslationManager has no resources to load (" + this.getLocale() + ")");
            }
            for (Class<?> c : this.classes) {
                boolean loaded = this.loadTranslation(this.getLocale(), c);
                if (loaded) continue;
                Log.get().warning("TranslationManager was unable to load translation " + c.getCanonicalName() + " for locale " + this.getLocale());
            }
        }
    }

    private List<InputStream> findStream(Locale locale, Class<?> c, boolean rootLast) {
        ResourceBundle.Control cntrl = CONTROL;
        ArrayList<InputStream> res = new ArrayList<InputStream>();
        String baseName = String.valueOf(c.getPackage().getName()) + "." + BASENAME;
        Locale targetLocale = locale;
        while (targetLocale != null && res.isEmpty()) {
            for (Locale candidate : cntrl.getCandidateLocales(baseName, targetLocale)) {
                InputStream ins = c.getClassLoader().getResourceAsStream(cntrl.toResourceName(cntrl.toBundleName(baseName, candidate), "xml"));
                if (ins == null) continue;
                res.add(ins);
            }
            targetLocale = cntrl.getFallbackLocale(baseName, targetLocale);
        }
        if (!rootLast) {
            Collections.reverse(res);
        }
        return res;
    }

    private boolean loadTranslation(Locale l, Class<?> c) {
        boolean translationLoaded = false;
        for (InputStream input : this.findStream(l, c, false)) {
            HashMap<String, String> menuTranslation = new HashMap<String, String>();
            HashMap<String, String> itemTranslation = new HashMap<String, String>();
            HashMap<String, String> actionTranslation = new HashMap<String, String>();
            TranslationManager.loadTranslation(input, menuTranslation, itemTranslation, actionTranslation);
            this.menuTranslation.putAll(menuTranslation);
            this.itemTranslation.putAll(itemTranslation);
            this.actionTranslation.putAll(actionTranslation);
            translationLoaded = true;
        }
        return translationLoaded;
    }

    private static void loadTranslation(InputStream input, Map<String, String> menuTranslation, Map<String, String> itemTranslation, Map<String, String> actionTranslation) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            try {
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(input);
                TranslationManager.loadTranslation(doc, "menu", menuTranslation);
                TranslationManager.loadTranslation(doc, "item", itemTranslation);
                TranslationManager.loadTranslation(doc, "action", actionTranslation);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadTranslation(Document doc, String tagName, Map<String, String> m) {
        NodeList menuChildren = doc.getElementsByTagName(tagName);
        int size = menuChildren.getLength();
        int i = 0;
        while (i < size) {
            Element element = (Element)menuChildren.item(i);
            String id = element.getAttributeNode("id").getValue();
            String label = element.getAttributeNode("label").getValue();
            if (m.containsKey(id)) {
                throw new IllegalStateException("Duplicate " + tagName + " translation entry for " + id + " (" + label + ")");
            }
            m.put(id, label);
            ++i;
        }
    }
}

