/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openconcerto.utils.CompareUtils;

public class ValidState {
    private static final ValidState TRUE = new ValidState(true, null);
    private static final ValidState FALSE = new ValidState(false, null);
    private static final Map<String, ValidState> cache = new LinkedHashMap<String, ValidState>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ValidState> eldest) {
            return this.size() > 50;
        }
    };
    private final boolean valid;
    private final String reason;

    public static final ValidState getTrueInstance() {
        return TRUE;
    }

    public static final ValidState getNoReasonInstance(boolean isValid) {
        return isValid ? TRUE : FALSE;
    }

    public static final ValidState create(boolean valid, String invalidityReason) {
        return ValidState.create(valid, invalidityReason, false);
    }

    public static final ValidState createCached(boolean valid, String invalidityReason) {
        return ValidState.create(valid, invalidityReason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ValidState create(boolean valid, String reason, boolean cacheNonValid) {
        if (valid) {
            return TRUE;
        }
        if (reason == null) {
            return FALSE;
        }
        if (cacheNonValid) {
            Map<String, ValidState> map = cache;
            synchronized (map) {
                ValidState res = cache.get(reason);
                if (res == null) {
                    res = new ValidState(valid, reason);
                    cache.put(reason, res);
                }
                return res;
            }
        }
        return new ValidState(valid, reason);
    }

    public static final ValidState createInvalid(String reason) {
        return new ValidState(false, reason);
    }

    public ValidState(boolean valid, String invalidityReason) {
        this.valid = valid;
        this.reason = valid ? null : invalidityReason;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getValidationText() {
        return this.reason;
    }

    private final boolean validationTextIsEmpty() {
        return this.reason == null || this.reason.trim().length() == 0;
    }

    public ValidState and(ValidState other) {
        return this.and(other, "\n");
    }

    public ValidState and(ValidState other, String sep) {
        if (this.equals(other)) {
            return this;
        }
        if (this.equals(TRUE)) {
            return other;
        }
        if (other.equals(TRUE)) {
            return this;
        }
        String reason = CompareUtils.equals(this.getValidationText(), other.getValidationText()) ? this.getValidationText() : (this.validationTextIsEmpty() ? other.getValidationText() : (other.validationTextIsEmpty() ? this.getValidationText() : String.valueOf(this.getValidationText()) + sep + other.getValidationText()));
        return new ValidState(this.isValid() && other.isValid(), reason);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.valid ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidState other = (ValidState)obj;
        return this.valid == other.valid && CompareUtils.equals(this.reason, other.reason);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.isValid() ? " valid" : " not valid : '" + this.getValidationText() + "'");
    }
}

