/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.openconcerto.utils.DropperQueue;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;

public class SleepingQueue {
    private static final ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(2, new ThreadFactory("DieMonitor", true).setPriority(1));
    private final String name;
    private RunningState state;
    private final PropertyChangeSupport support;
    private FutureTask<?> beingRun;
    private final SingleThreadedExecutor tasksQueue;
    private boolean canceling;
    private IPredicate<FutureTask<?>> cancelPredicate;

    static {
        exec.setKeepAliveTime(30L, TimeUnit.SECONDS);
        exec.allowCoreThreadTimeOut(true);
        exec.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        exec.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        assert (exec.getPoolSize() == 0) : "Wasting resources";
    }

    public static final ScheduledFuture<?> watchDying(LethalFutureTask<?> lethalFuture) {
        return SleepingQueue.watchDying(lethalFuture, 1, 1, TimeUnit.MINUTES);
    }

    public static final ScheduledFuture<?> watchDying(LethalFutureTask<?> lethalFuture, int initialDelay, int delay, TimeUnit unit) {
        return SleepingQueue.watchDying(lethalFuture, initialDelay, delay, unit, null);
    }

    static final ScheduledFuture<?> watchDying(final LethalFutureTask<?> lethalFuture, int initialDelay, int delay, TimeUnit unit, final IClosure<? super ExecutionException> exnHandler) {
        final AtomicReference f = new AtomicReference();
        ScheduledFuture<?> res = exec.scheduleWithFixedDelay(new Runnable(){

            private void wontKill(RunningState runningState, boolean isDone) {
                Log.get().fine("Our watched future won't kill the queue, current state : " + (Object)((Object)runningState) + " " + lethalFuture);
                if (isDone) {
                    this.cancel();
                }
            }

            private void cancel() {
                if (!$assertionsDisabled && !lethalFuture.isDone()) {
                    throw new AssertionError();
                }
                try {
                    lethalFuture.get();
                }
                catch (InterruptedException e) {
                    Log.get().log(Level.FINER, "Interrupted while waiting on a finished future " + lethalFuture, e);
                }
                catch (ExecutionException e) {
                    if (exnHandler == null) {
                        Log.get().log(Level.WARNING, "Threw an exception : " + lethalFuture, e);
                    }
                    exnHandler.executeChecked(e);
                }
                ((Future)f.get()).cancel(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean isDone;
                FutureTask<?> beingRun;
                RunningState runningState;
                SleepingQueue q;
                SleepingQueue sleepingQueue = q = lethalFuture.getQueue();
                synchronized (sleepingQueue) {
                    runningState = q.getRunningState();
                    beingRun = q.getBeingRun();
                    isDone = lethalFuture.isDone();
                }
                Level l = Level.INFO;
                if (runningState == RunningState.RUNNING) {
                    this.wontKill(runningState, isDone);
                } else if (runningState == RunningState.WILL_DIE) {
                    if (isDone) {
                        this.wontKill(runningState, isDone);
                    } else if (beingRun == lethalFuture) {
                        Log.get().log(l, "Pre-death has not yet finished " + lethalFuture);
                    } else {
                        Log.get().log(l, "Death has not yet begun for " + lethalFuture + "\ncurrently running : " + beingRun);
                    }
                } else if (runningState == RunningState.DYING) {
                    if (!$assertionsDisabled && beingRun != null && !(beingRun instanceof LethalFutureTask)) {
                        throw new AssertionError();
                    }
                    if (beingRun == null) {
                        if (!$assertionsDisabled && !isDone) {
                            throw new AssertionError();
                        }
                        Log.get().log(l, "Death was carried out but the thread is not yet terminated. Watching " + lethalFuture);
                    } else if (beingRun == lethalFuture) {
                        Log.get().log(l, "Post-death has not yet finished " + lethalFuture);
                    } else {
                        if (!$assertionsDisabled && !isDone) {
                            throw new AssertionError();
                        }
                        this.wontKill(runningState, isDone);
                    }
                } else if (runningState == RunningState.DEAD) {
                    Log.get().log(l, "Death was carried out and the thread is terminated but not necessarily by " + lethalFuture);
                    this.cancel();
                } else {
                    Log.get().warning("Illegal state " + (Object)((Object)runningState) + " for " + lethalFuture);
                }
            }
        }, initialDelay, delay, unit);
        f.set(res);
        return res;
    }

    public SleepingQueue() {
        this(String.valueOf(SleepingQueue.class.getName()) + System.currentTimeMillis());
    }

    public SleepingQueue(String name) {
        this.name = name;
        this.state = RunningState.NEW;
        this.canceling = false;
        this.cancelPredicate = null;
        this.support = new PropertyChangeSupport(this);
        this.setBeingRun(null);
        this.tasksQueue = new SingleThreadedExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            this.tasksQueue.start();
            this.setState(RunningState.RUNNING);
            this.started();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startIfNew() {
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            boolean starting;
            boolean bl = starting = this.state == RunningState.NEW;
            if (starting) {
                this.start();
            }
            assert (this.state.compareTo(RunningState.NEW) > 0);
            return starting;
        }
    }

    protected void started() {
    }

    protected final synchronized void setState(RunningState s) {
        this.state = s;
    }

    public final synchronized RunningState getRunningState() {
        if (this.state == RunningState.NEW || this.tasksQueue.isAlive()) {
            return this.state;
        }
        return RunningState.DEAD;
    }

    public final boolean currentlyInQueue() {
        return Thread.currentThread() == this.tasksQueue;
    }

    protected void customizeThread(Thread thr) {
        thr.setPriority(1);
    }

    protected final <T> FutureTask<T> newTaskFor(Runnable task) {
        return this.newTaskFor(task, null);
    }

    protected <T> FutureTask<T> newTaskFor(Runnable task, T value) {
        return new IFutureTask<T>(task, value, " for {" + this.name + "}");
    }

    public final FutureTask<?> put(Runnable workRunnable) {
        FutureTask t = workRunnable instanceof FutureTask ? (FutureTask)workRunnable : this.newTaskFor(workRunnable);
        return this.execute(t);
    }

    public final <F extends FutureTask<?>> F execute(F t) {
        if (this.shallAdd(t)) {
            this.add(t);
            return t;
        }
        return null;
    }

    private void add(FutureTask<?> t) {
        if (this.dieCalled()) {
            throw new IllegalStateException("Already dead, cannot exec " + t);
        }
        this.tasksQueue.put(t);
    }

    private final boolean shallAdd(FutureTask<?> runnable) {
        if (runnable == null) {
            throw new NullPointerException("null runnable");
        }
        try {
            this.willPut(runnable);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void willPut(FutureTask<?> r) throws InterruptedException {
    }

    protected void exceptionThrown(ExecutionException exn) {
        exn.printStackTrace();
    }

    protected final void cancel() {
        this.cancel(null);
    }

    protected final void cancel(final IPredicate<FutureTask<?>> pred) {
        this.tasksDo(new IClosure<Collection<FutureTask<?>>>(){

            @Override
            public void executeChecked(Collection<FutureTask<?>> tasks) {
                SleepingQueue.this.cancel(pred, tasks);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancel(IPredicate<FutureTask<?>> pred, Collection<FutureTask<?>> tasks) {
        try {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = true;
                this.cancelPredicate = pred;
                this.cancelCheck(this.getBeingRun());
            }
            for (FutureTask<?> t : tasks) {
                this.cancelCheck(t);
            }
        }
        catch (Throwable throwable) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = false;
                this.cancelPredicate = null;
            }
            throw throwable;
        }
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            this.canceling = false;
            this.cancelPredicate = null;
        }
    }

    public final void tasksDo(IClosure<? super Deque<FutureTask<?>>> c) {
        this.tasksQueue.itemsDo(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCheck(FutureTask<?> t) {
        if (t != null) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                if (this.canceling && (this.cancelPredicate == null || this.cancelPredicate.evaluateChecked(t))) {
                    t.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeingRun(FutureTask<?> beingRun) {
        FutureTask<?> old;
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            old = this.beingRun;
            this.beingRun = beingRun;
        }
        this.support.firePropertyChange("beingRun", old, beingRun);
    }

    public final synchronized FutureTask<?> getBeingRun() {
        return this.beingRun;
    }

    public boolean isSleeping() {
        return this.tasksQueue.isSleeping();
    }

    public boolean setSleeping(boolean sleeping) {
        boolean res = this.tasksQueue.setSleeping(sleeping);
        if (res) {
            this.support.firePropertyChange("sleeping", null, (Object)sleeping);
        }
        return res;
    }

    public final LethalFutureTask<?> die() {
        return this.die(true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> LethalFutureTask<V> die(final boolean force, final Runnable willDie, final Callable<V> dying) throws IllegalStateException {
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            RunningState state = this.getRunningState();
            if (state == RunningState.NEW) {
                throw new IllegalStateException("Not started");
            }
            if (state.compareTo(RunningState.RUNNING) > 0) {
                throw new IllegalStateException("die() already called or thread was killed by an Error : " + (Object)((Object)state));
            }
            assert (state == RunningState.RUNNING);
            this.setState(RunningState.WILL_DIE);
        }
        final AtomicBoolean resetSleeping = new AtomicBoolean(false);
        final LethalFutureTask res = new LethalFutureTask(this, new Callable<V>(){

            @Override
            public V call() throws Exception {
                Exception willDieExn;
                block12: {
                    willDieExn = null;
                    try {
                        SleepingQueue.this.willDie();
                        if (willDie == null) break block12;
                        willDie.run();
                        if (!(willDie instanceof Future)) break block12;
                        Future f = (Future)((Object)willDie);
                        if (!$assertionsDisabled && !f.isDone()) {
                            throw new AssertionError((Object)("Ran but not done: " + f));
                        }
                        try {
                            f.get();
                        }
                        catch (ExecutionException e) {
                            throw (Exception)e.getCause();
                        }
                    }
                    catch (Exception e) {
                        if (!force) {
                            SleepingQueue.this.setState(RunningState.RUNNING);
                            throw e;
                        }
                        willDieExn = e;
                    }
                }
                try {
                    SleepingQueue.this.tasksQueue.die(false);
                    if (!$assertionsDisabled && !SleepingQueue.this.tasksQueue.isDying()) {
                        throw new AssertionError();
                    }
                    SleepingQueue.this.setState(RunningState.DYING);
                    if (willDieExn != null) {
                        throw willDieExn;
                    }
                    SleepingQueue.this.dying();
                    Object res = dying != null ? (Object)dying.call() : null;
                    Object v = res;
                    return v;
                }
                finally {
                    if (resetSleeping.get()) {
                        SleepingQueue.this.tasksQueue.setSleeping(true);
                    }
                }
            }
        });
        this.tasksQueue.itemsDo(new IClosure<Deque<FutureTask<?>>>(){

            @Override
            public void executeChecked(Deque<FutureTask<?>> input) {
                for (FutureTask<?> ft : input) {
                    ft.cancel(false);
                }
                input.clear();
                input.addFirst(res);
                FutureTask<?> beingRun = SleepingQueue.this.getBeingRun();
                if (!$assertionsDisabled && beingRun == res) {
                    throw new AssertionError((Object)("beingRun: " + beingRun + " ; res: " + res));
                }
                if (beingRun != null) {
                    beingRun.cancel(true);
                }
            }
        });
        resetSleeping.set(this.setSleeping(false));
        return res;
    }

    protected void willDie() {
    }

    protected void dying() throws Exception {
    }

    public final boolean dieCalled() {
        return this.tasksQueue.dieCalled();
    }

    public final boolean isDead() {
        return this.tasksQueue.isDead();
    }

    public final void join() throws InterruptedException {
        this.tasksQueue.join();
    }

    public final void join(long millis, int nanos) throws InterruptedException {
        this.tasksQueue.join(millis, nanos);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeCurrentTask) {
        return String.valueOf(super.toString()) + " Queue: " + this.tasksQueue + (includeCurrentTask ? " run:" + this.getBeingRun() : "");
    }

    public static final class LethalFutureTask<V>
    extends FutureTask<V> {
        private final SleepingQueue q;

        public LethalFutureTask(SleepingQueue q, Callable<V> c) {
            super(c);
            this.q = q;
        }

        public final SleepingQueue getQueue() {
            return this.q;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getQueue().toString(false);
        }
    }

    public static enum RunningState {
        NEW,
        RUNNING,
        WILL_DIE,
        DYING,
        DEAD;

    }

    private final class SingleThreadedExecutor
    extends DropperQueue<FutureTask<?>> {
        private SingleThreadedExecutor() {
            super(String.valueOf(SleepingQueue.this.name) + System.currentTimeMillis());
            SleepingQueue.this.customizeThread(this);
        }

        @Override
        protected void process(FutureTask<?> task) {
            block3: {
                if (!task.isDone()) {
                    boolean ran = false;
                    this.beforeExecute(task);
                    try {
                        task.run();
                        ran = true;
                        this.afterExecute(task, null);
                    }
                    catch (RuntimeException ex) {
                        if (ran) break block3;
                        this.afterExecute(task, ex);
                    }
                }
            }
        }

        protected void beforeExecute(FutureTask<?> f) {
            SleepingQueue.this.cancelCheck(f);
            SleepingQueue.this.setBeingRun(f);
        }

        protected void afterExecute(FutureTask<?> f, Throwable t) {
            SleepingQueue.this.setBeingRun(null);
            try {
                f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                SleepingQueue.this.exceptionThrown(e);
            }
        }
    }
}

