/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;
import org.openconcerto.utils.cc.Transformer;

public class CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private static final IdentitySet EMPTY_SET = new EmptyIdentitySet();

    public static final <E> String join(Collection<E> c, String sep, ITransformer<? super E, ?> tf) {
        int size = c.size();
        if (size == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(size * 4);
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int i = 0;
            while (i < size) {
                res.append(tf.transformChecked(list.get(i)));
                if (i < size - 1) {
                    res.append(sep);
                }
                ++i;
            }
        } else {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                E elem = iter.next();
                res.append(tf.transformChecked(elem));
                if (!iter.hasNext()) continue;
                res.append(sep);
            }
        }
        return res.toString();
    }

    public static <T> String join(Collection<T> c, String sep) {
        return CollectionUtils.join(c, sep, Transformer.nopTransformer());
    }

    public static <T, U, C extends Collection<? super U>> C transform(Collection<T> c, ITransformer<? super T, U> transf, C res) {
        return CollectionUtils.transformAndFilter(c, transf, IPredicate.truePredicate(), res);
    }

    public static <T, U, C extends Collection<? super U>> C transformAndFilter(Collection<T> c, ITransformer<? super T, U> transf, IPredicate<? super U> filterAfter, C res) {
        return CollectionUtils.filterTransformAndFilter(c, IPredicate.truePredicate(), transf, filterAfter, res);
    }

    public static <T, U, C extends Collection<? super U>> C filterAndTransform(Collection<T> c, IPredicate<? super T> filterBefore, ITransformer<? super T, U> transf, C res) {
        return CollectionUtils.filterTransformAndFilter(c, filterBefore, transf, IPredicate.truePredicate(), res);
    }

    public static <T, U, C extends Collection<? super U>> C filterTransformAndFilter(Collection<T> c, IPredicate<? super T> filterBefore, final ITransformer<? super T, U> transf, final IPredicate<? super U> filterAfter, final C res) {
        CollectionUtils.iterate(c, filterBefore, new IClosure<T>(){

            @Override
            public void executeChecked(T input) {
                Object item = transf.transformChecked(input);
                if (filterAfter.evaluateChecked(item)) {
                    res.add(item);
                }
            }
        });
        return res;
    }

    public static <T> void iterate(Collection<T> c, IClosure<T> cl) {
        CollectionUtils.iterate(c, IPredicate.truePredicate(), cl);
    }

    public static <T> void iterate(Collection<T> c, IPredicate<? super T> filterBefore, IClosure<T> cl) {
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int size = c.size();
            int i = 0;
            while (i < size) {
                Object item = list.get(i);
                if (filterBefore.evaluateChecked(item)) {
                    cl.executeChecked(item);
                }
                ++i;
            }
        } else {
            for (T item : c) {
                if (!filterBefore.evaluateChecked(item)) continue;
                cl.executeChecked(item);
            }
        }
    }

    public static List<String> split(String s) {
        return CollectionUtils.split(s, COMMA);
    }

    public static List<String> split(String s, String sep) {
        return CollectionUtils.split(s, Pattern.compile(sep));
    }

    public static List<String> split(String s, Pattern pattern) {
        return s.length() == 0 ? Collections.emptyList() : Arrays.asList(pattern.split(s));
    }

    public static int getValidIndex(List<?> l, int i) throws IndexOutOfBoundsException {
        return CollectionUtils.getValidIndex(l, i, true);
    }

    public static int getValidIndex(List<?> l, int i, boolean strict) throws IndexOutOfBoundsException {
        int size = l.size();
        if (i > size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too high : " + i + " > " + size);
            }
            return size;
        }
        if (i < -size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too low : " + i + " < " + -size);
            }
            return 0;
        }
        if (i >= 0) {
            return i;
        }
        return size + i;
    }

    public static void delete(List<?> l, int from, int to) {
        if (!l.isEmpty()) {
            l.subList(CollectionUtils.getValidIndex(l, from, false), CollectionUtils.getValidIndex(l, to, false) + 1).clear();
        }
    }

    public static void delete(List<?> l, int from) {
        CollectionUtils.delete(l, from, -1);
    }

    public static <T> void filter(Collection<T> collection, IPredicate<? super T> predicate) {
        org.apache.commons.collections.CollectionUtils.filter(collection, predicate);
    }

    public static <T> boolean exists(Collection<T> collection, IPredicate<? super T> predicate) {
        return org.apache.commons.collections.CollectionUtils.exists(collection, predicate);
    }

    public static <K, V> Tuple2<List<K>, List<V>> mapToLists(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> vals = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keys.add(e.getKey());
            vals.add(e.getValue());
        }
        return Tuple2.create(keys, vals);
    }

    public static <K, V> Map<K, V> addIfNotPresent(Map<K, V> map, Map<? extends K, ? extends V> toAdd) {
        for (Map.Entry<K, V> e : toAdd.entrySet()) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <E> List<Integer> getIndexesChanged(List<E> oldList, List<E> newList) {
        ArrayList<E> shorter;
        ArrayList<E> longer;
        if (newList.size() > oldList.size()) {
            longer = new ArrayList<E>(newList);
            shorter = new ArrayList<E>(oldList);
        } else {
            longer = new ArrayList<E>(oldList);
            shorter = new ArrayList<E>(newList);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        int offset = 0;
        while (shorter.size() > 0) {
            if (longer.size() < shorter.size()) {
                throw new IllegalStateException(shorter + " is not a sublist of " + longer);
            }
            if (CompareUtils.equals(shorter.get(0), longer.get(0))) {
                shorter.remove(0);
                longer.remove(0);
            } else {
                longer.remove(0);
                res.add(offset);
            }
            ++offset;
        }
        int i = 0;
        while (i < longer.size()) {
            res.add(i + offset);
            ++i;
        }
        return res;
    }

    public static List<int[]> aggregate(Collection<? extends Number> ints) {
        ArrayList<int[]> res = new ArrayList<int[]>();
        int[] currentInterval = null;
        for (Number number : ints) {
            int index = number.intValue();
            if (currentInterval == null || index != currentInterval[1] + 1) {
                currentInterval = new int[]{index, currentInterval[0]};
                res.add(currentInterval);
                continue;
            }
            currentInterval[1] = index;
        }
        return res;
    }

    public static <T> Set<T> contains(Set<T> col1, Set<T> col2) {
        if (col1.containsAll(col2)) {
            return null;
        }
        HashSet<T> names = new HashSet<T>(col2);
        names.removeAll(col1);
        return names;
    }

    public static <C extends Collection<?>> boolean containsAny(C coll1, C coll2) {
        return !Collections.disjoint(coll1, coll2);
    }

    public static final <T> boolean identityContains(Collection<T> coll, T item) {
        for (T v : coll) {
            if (item != v) continue;
            return true;
        }
        return false;
    }

    public static <U, T extends U> List<T> castToList(U[] array, Class<T> clazz) throws ClassCastException {
        ArrayList<T> res = new ArrayList<T>(array.length);
        U[] UArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            U item = UArray[n2];
            res.add(clazz.cast(item));
            ++n2;
        }
        return res;
    }

    public static <E> List<E> castList(List<?> list, Class<E> c) throws ClassCastException {
        if (list == null) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>();
        int i = 0;
        while (i < list.size()) {
            result.add(c.cast(list.get(i)));
            ++i;
        }
        return result;
    }

    public static <E, F> Map<E, F> castMap(Map<?, ?> map, Class<E> cKey, Class<F> cValue) throws ClassCastException {
        if (map == null) {
            return null;
        }
        HashMap<E, F> result = new HashMap<E, F>();
        for (Map.Entry<?, ?> mapEntry : map.entrySet()) {
            F value;
            E key;
            try {
                key = cKey.cast(mapEntry.getKey());
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("Key " + mapEntry.getKey().toString() + " is not valid: " + ex.getMessage());
            }
            try {
                value = cValue.cast(mapEntry.getValue());
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("Value " + mapEntry.getKey().toString() + " is not valid: " + ex.getMessage());
            }
            result.put(key, value);
        }
        return result;
    }

    public static <T> int equalsFromEnd(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, true, null);
    }

    public static <T> int equalsFromStart(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, false, null);
    }

    public static final <A, B> int equals(List<A> a, List<B> b, boolean fromEnd, ITransformer<A, B> transf) {
        int sizeA = a.size();
        int sizeB = b.size();
        int lastI = Math.min(sizeA, sizeB);
        int i = 0;
        while (i < lastI) {
            B itemB;
            A itemA = a.get(fromEnd ? sizeA - 1 - i : i);
            if (!CompareUtils.equals(transf == null ? itemA : transf.transformChecked(itemA), itemB = b.get(fromEnd ? sizeB - 1 - i : i))) {
                return i;
            }
            ++i;
        }
        return lastI;
    }

    public static final <T> int getEqualsCount(Iterator<? extends T> a, Iterator<? extends T> b) {
        return CollectionUtils.getEqualsCount(a, b, null);
    }

    public static final <A, B> int getEqualsCount(Iterator<A> a, Iterator<B> b, ITransformer<A, B> transf) {
        int res = 0;
        while (a.hasNext() && b.hasNext()) {
            B itemB;
            A itemA = a.next();
            if (!CompareUtils.equals(transf == null ? itemA : transf.transformChecked(itemA), itemB = b.next())) break;
            ++res;
        }
        return res;
    }

    public static <T> Collection<T> select(Collection<T> a, IPredicate<? super T> pred) {
        return CollectionUtils.select(a, pred, new ArrayList());
    }

    public static <T, C extends Collection<? super T>> C select(Collection<T> a, IPredicate<? super T> pred, C b) {
        for (T item : a) {
            if (!pred.evaluateChecked(item)) continue;
            b.add(item);
        }
        return b;
    }

    public static <T> Collection<T> intersection(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections.CollectionUtils.intersection(a, b);
    }

    public static <T> Set<T> inter(Set<T> a, Set<T> b) {
        return CollectionUtils.interSubtype(a, b);
    }

    public static <T> Set<? extends T> interSubtype(Set<? extends T> a, Set<? extends T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.size() > b.size()) {
            return CollectionUtils.interSubtype(b, a);
        }
        HashSet<T> res = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T> Set<T> inter(Set<T> ... sets) {
        return CollectionUtils.inter(Arrays.asList(sets));
    }

    public static <T> Set<T> inter(List<Set<T>> sets) {
        ArrayList<Set<T>> mutable = new ArrayList<Set<T>>(sets.size());
        for (Set<T> s : sets) {
            if (s == null) continue;
            mutable.add(s);
        }
        if (mutable.isEmpty()) {
            return null;
        }
        if (mutable.size() == 1) {
            return (Set)mutable.get(0);
        }
        int indexMin = CollectionUtils.indexOfMinSize(mutable);
        if (indexMin != 0) {
            mutable.add(0, (Set)mutable.remove(indexMin));
            return CollectionUtils.inter(mutable);
        }
        if (((Set)mutable.get(0)).isEmpty()) {
            return Collections.emptySet();
        }
        mutable.add(0, CollectionUtils.inter((Set)mutable.remove(0), (Set)mutable.remove(0)));
        return CollectionUtils.inter(mutable);
    }

    private static final <T> int indexOfMinSize(List<Set<T>> sets) {
        if (sets.isEmpty()) {
            throw new IllegalArgumentException("empty sets");
        }
        int res = 0;
        int i = 1;
        while (i < sets.size()) {
            if (sets.get(i).size() < sets.get(res).size()) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        HashSet<T> res = new HashSet<T>(a);
        if (a != b) {
            res.addAll(b);
        }
        return res;
    }

    public static <T> Set<T> union(Collection<? extends Collection<? extends T>> colls) {
        return CollectionUtils.union(new HashSet(), colls);
    }

    public static <T> List<T> cat(Collection<? extends Collection<? extends T>> colls) {
        return CollectionUtils.union(new ArrayList(), colls);
    }

    public static <T, C extends Collection<? super T>> C union(C collector, Collection<? extends Collection<? extends T>> colls) {
        return CollectionUtils.union(collector, colls, Transformer.nopTransformer());
    }

    public static <T, C extends Collection<? super T>, A> C union(C collector, Collection<? extends A> colls, ITransformer<? super A, ? extends Collection<? extends T>> transf) {
        for (A coll : colls) {
            collector.addAll(transf.transformChecked(coll));
        }
        return collector;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> Collection<T> substract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static final <T> T coalesce(T o1, T o2) {
        return o1 != null ? o1 : o2;
    }

    public static final <T> T coalesce(T ... objects) {
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o != null) {
                return o;
            }
            ++n2;
        }
        return null;
    }

    public static <T> T getSole(Collection<T> l, boolean atMostOne) throws IllegalArgumentException {
        int size = l.size();
        if (atMostOne && size > 1) {
            throw new IllegalArgumentException("More than one");
        }
        if (size != 1) {
            return null;
        }
        if (l instanceof List) {
            return (T)((List)l).get(0);
        }
        return l.iterator().next();
    }

    public static <T> T getSole(Collection<T> l) {
        return CollectionUtils.getSole(l, false);
    }

    public static <T> T getFirst(Collection<T> l) {
        return l.size() > 0 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(List<T> l) {
        return CollectionUtils.getNoExn(l, 0);
    }

    public static <T> T getLast(List<T> l) {
        return CollectionUtils.getNoExn(l, l.size() - 1);
    }

    public static <T> T getNoExn(List<T> l, int index) {
        return index >= 0 && index < l.size() ? (T)l.get(index) : null;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> LinkedList<T> toLinkedList(Iterator<T> iter) {
        return CollectionUtils.addTo(iter, new LinkedList());
    }

    public static <T> ArrayList<T> toArrayList(Iterator<T> iter, int estimatedSize) {
        return CollectionUtils.addTo(iter, new ArrayList(estimatedSize));
    }

    public static <T, C extends Collection<? super T>> C addTo(Iterator<T> iter, C c) {
        while (iter.hasNext()) {
            c.add(iter.next());
        }
        return c;
    }

    public static <T> ListIterator<T> getListIterator(List<T> l, boolean reversed) {
        if (!reversed) {
            return l.listIterator();
        }
        return CollectionUtils.reverseListIterator(l.listIterator(l.size()));
    }

    public static <T> ListIterator<T> reverseListIterator(ListIterator<T> listIter) {
        if (listIter instanceof ReverseListIter) {
            return ((ReverseListIter)listIter).listIter;
        }
        return new ReverseListIter(listIter);
    }

    public static <T> List<T> createList(T item1, T item2) {
        ArrayList<T> res = new ArrayList<T>();
        res.add(item1);
        res.add(item2);
        return res;
    }

    public static <T> List<T> createList(T item1, T item2, T item3) {
        List<T> res = CollectionUtils.createList(item1, item2);
        res.add(item3);
        return res;
    }

    public static <T> Set<T> createSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> IdentitySet<T> createIdentitySet(T ... items) {
        return new IdentityHashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> toIdentitySet(Collection<T> items) {
        if (items instanceof IdentitySet) {
            return (Set)items;
        }
        return new IdentityHashSet<T>(items);
    }

    public static <T> IdentitySet<T> emptyIdentitySet() {
        return EMPTY_SET;
    }

    public static <K, V> Map<K, V> createMap(K key, V val, K key2, V val2) {
        LinkedHashMap<K, V> res = new LinkedHashMap<K, V>();
        res.put(key, val);
        res.put(key2, val2);
        return res;
    }

    public static <K, V> Map<K, V> createMap(K key, V val, K key2, V val2, K key3, V val3) {
        Map<K, V> res = CollectionUtils.createMap(key, val, key2, val2);
        res.put(key3, val3);
        return res;
    }

    public static <K, V> Map<K, V> createMap(Collection<? extends K> keys) {
        return CollectionUtils.fillMap(keys instanceof List ? new LinkedHashMap(keys.size()) : new HashMap(keys.size()), keys);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> keys) {
        return CollectionUtils.fillMap(m, keys, null);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> keys, V val) {
        for (K key : keys) {
            m.put(key, val);
        }
        return m;
    }

    public static <K, V, M extends Map<K, V>> M invertMap(M m, Map<? extends V, ? extends K> source) {
        for (Map.Entry<V, K> e : source.entrySet()) {
            m.put(e.getValue(), e.getKey());
        }
        return m;
    }

    public static <K, V, M extends CollectionMap2Itf<K, ?, V>> M invertMap(M m, Map<? extends V, ? extends K> source) {
        for (Map.Entry<V, K> e : source.entrySet()) {
            m.add(e.getValue(), e.getKey());
        }
        return m;
    }

    private static final class EmptyIdentitySet
    extends AbstractSet<Object>
    implements Serializable,
    IdentitySet<Object> {
        private EmptyIdentitySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return CollectionUtils.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    private static final class ReverseListIter<T>
    implements ListIterator<T> {
        private final ListIterator<T> listIter;

        private ReverseListIter(ListIterator<T> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasPrevious();
        }

        @Override
        public T next() {
            return this.listIter.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.listIter.hasNext();
        }

        @Override
        public T previous() {
            return this.listIter.next();
        }

        @Override
        public int nextIndex() {
            return this.listIter.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.listIter.nextIndex();
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }

        @Override
        public void set(T e) {
            this.listIter.set(e);
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

