/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringUtils;

public abstract class BaseDirs {
    private static final String DATA = "Data";
    private static final String PREFERENCES = "Preferences";
    private static final String CACHES = "Caches";
    private final ProductInfo info;
    private final String subdir;

    public static final BaseDirs createPortable(File rootDir, ProductInfo info, String subdir) {
        return new Portable(rootDir, info, subdir);
    }

    public static final BaseDirs create(ProductInfo info) {
        return BaseDirs.create(info, null);
    }

    public static final BaseDirs create(ProductInfo info, String subdir) {
        OSFamily os = OSFamily.getInstance();
        if (os == OSFamily.Windows) {
            return new Windows(info, subdir);
        }
        if (os == OSFamily.Mac) {
            return new Mac(info, subdir);
        }
        if (os instanceof OSFamily.Unix) {
            return new XDG(info, subdir);
        }
        return new Unknown(info, subdir);
    }

    protected BaseDirs(ProductInfo info, String subdir) {
        this.info = info;
        this.subdir = subdir == null ? null : FileUtils.sanitize(subdir);
    }

    private final ProductInfo getInfo() {
        return this.info;
    }

    protected final String getAppName() {
        return FileUtils.sanitize(this.getInfo().getName());
    }

    protected final String getAppID() {
        return this.getInfo().getID();
    }

    protected final String getAppFullID() {
        String res = this.getInfo().getFullID();
        return res != null ? res : this.getAppID();
    }

    protected File getFolderToWrite(File dir) throws IOException {
        if (dir.isDirectory() && dir.canWrite()) {
            return dir;
        }
        if (dir.exists()) {
            throw new IOException(String.valueOf(dir.isDirectory() ? "Not writable: " : "Not a directory: ") + dir);
        }
        if (this instanceof Windows) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        } else {
            Files.createDirectories(dir.toPath(), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
        }
        return dir;
    }

    protected final File getSubDir(File dir) {
        return this.subdir == null ? dir : new File(dir, this.subdir);
    }

    protected File _getAppDataFolder() {
        return new File(System.getProperty("user.home"), "." + this.getAppFullID());
    }

    public final File getAppDataFolder() {
        return this.getSubDir(this._getAppDataFolder());
    }

    public final File getAppDataFolderToWrite() throws IOException {
        return this.getFolderToWrite(this.getAppDataFolder());
    }

    protected File _getPreferencesFolder() {
        return this.getAppDataFolder();
    }

    public final File getPreferencesFolder() {
        return this.getSubDir(this._getPreferencesFolder());
    }

    public final File getPreferencesFolderToWrite() throws IOException {
        return this.getFolderToWrite(this.getPreferencesFolder());
    }

    protected File _getCacheFolder() {
        return new File(System.getProperty("java.io.tmpdir"), this.getAppFullID());
    }

    public final File getCacheFolder() {
        return this.getSubDir(this._getCacheFolder());
    }

    public final File getCacheFolderToWrite() throws IOException {
        return this.getFolderToWrite(this.getCacheFolder());
    }

    public String toString() {
        return String.valueOf(BaseDirs.class.getSimpleName()) + " " + this.getClass().getSimpleName();
    }

    public static void main(String[] args) {
        String appName = args.length > 0 ? args[0] : "fooApp";
        String companyName = args.length > 1 ? args[1] : "acme";
        String subdir = System.getProperty("subdir");
        BaseDirs instance = BaseDirs.create(new ProductInfo(CollectionUtils.createMap("ORGANIZATION_NAME", companyName, "NAME", appName)), subdir);
        System.out.println(instance);
        System.out.println("app data : " + instance.getAppDataFolder());
        System.out.println("preferences : " + instance.getPreferencesFolder());
        System.out.println("cache : " + instance.getCacheFolder());
    }

    public static final class Mac
    extends BaseDirs {
        protected Mac(ProductInfo info, String subdir) {
            super(info, subdir);
        }

        @Override
        protected File _getAppDataFolder() {
            return new File(String.valueOf(System.getProperty("user.home")) + "/Library/" + this.getAppName());
        }

        @Override
        protected File _getPreferencesFolder() {
            return new File(String.valueOf(System.getProperty("user.home")) + "/Library/Preferences/" + this.getAppFullID());
        }

        @Override
        protected File _getCacheFolder() {
            return new File(String.valueOf(System.getProperty("user.home")) + "/Library/Caches/" + this.getAppFullID());
        }
    }

    public static final class Portable
    extends BaseDirs {
        private final File rootDir;

        protected Portable(File rootDir, ProductInfo info, String subdir) {
            super(info, subdir);
            this.rootDir = rootDir;
        }

        public final File getRootDir() {
            return this.rootDir;
        }

        @Override
        protected File _getAppDataFolder() {
            return new File(this.getRootDir(), BaseDirs.DATA);
        }

        @Override
        protected File _getPreferencesFolder() {
            return new File(this.getRootDir(), BaseDirs.PREFERENCES);
        }

        @Override
        protected File _getCacheFolder() {
            return new File(this.getRootDir(), BaseDirs.CACHES);
        }
    }

    public static final class Unknown
    extends BaseDirs {
        protected Unknown(ProductInfo info, String subdir) {
            super(info, subdir);
        }
    }

    public static final class Windows
    extends BaseDirs {
        private final String path;

        protected Windows(ProductInfo info, String subdir) {
            super(info, subdir);
            String orgID = info.getOrganizationName() == null ? null : FileUtils.sanitize(info.getOrganizationName());
            String appID = this.getAppName();
            String string = this.path = orgID == null || orgID.equals(appID) ? appID : String.valueOf(orgID) + File.separatorChar + appID;
            assert (this.path.charAt(0) != File.separatorChar && this.path.charAt(this.path.length() - 1) != File.separatorChar) : "Separator not in between : " + this.path;
        }

        protected final String getPath() {
            return this.path;
        }

        @Override
        protected File _getAppDataFolder() {
            return new File(System.getenv("APPDATA"), String.valueOf(this.getPath()) + File.separatorChar + BaseDirs.DATA);
        }

        @Override
        protected File _getPreferencesFolder() {
            return new File(System.getenv("APPDATA"), String.valueOf(this.getPath()) + File.separatorChar + BaseDirs.PREFERENCES);
        }

        @Override
        protected File _getCacheFolder() {
            return new File(System.getenv("LOCALAPPDATA"), String.valueOf(this.getPath()) + File.separatorChar + BaseDirs.CACHES);
        }
    }

    public static final class XDG
    extends BaseDirs {
        protected XDG(ProductInfo info, String subdir) {
            super(info, subdir);
        }

        @Override
        protected File _getAppDataFolder() {
            return new File(StringUtils.coalesce(System.getenv("XDG_DATA_HOME"), String.valueOf(System.getenv("HOME")) + "/.local/share"), this.getAppID());
        }

        @Override
        protected File _getPreferencesFolder() {
            return new File(StringUtils.coalesce(System.getenv("XDG_CONFIG_HOME"), String.valueOf(System.getenv("HOME")) + "/.config"), this.getAppID());
        }

        @Override
        protected File _getCacheFolder() {
            return new File(StringUtils.coalesce(System.getenv("XDG_CACHE_HOME"), String.valueOf(System.getenv("HOME")) + "/.cache"), this.getAppID());
        }
    }
}

