/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TreeItem
implements Serializable {
    private static final long serialVersionUID = 8087661728014786832L;
    private String id;
    private String label;
    private List<TreeItem> children;
    private boolean isSelected;
    private Color color;
    private boolean expanded;
    private String iconId;

    public TreeItem() {
    }

    public TreeItem(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public TreeItem getChild(int i) {
        return this.children.get(i);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public final List<TreeItem> getChildren() {
        return this.children;
    }

    public final void addChild(TreeItem item) {
        if (this.children == null) {
            this.children = new ArrayList<TreeItem>();
        }
        this.children.add(item);
    }

    public final void addChildren(List<TreeItem> items) {
        if (this.children == null) {
            this.children = new ArrayList<TreeItem>();
        }
        this.children.addAll(items);
    }

    public final void setChildren(List<TreeItem> children) {
        this.children = children;
    }

    public final boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public final String getIconId() {
        return this.iconId;
    }

    public final void setRightIconId(String iconId) {
        this.iconId = iconId;
    }
}

