/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.io.JSONConverter;

public class LightUISlider
extends LightUserControl {
    Integer maxValue = 1;
    Integer minValue = 0;
    Integer increment = 1;

    public LightUISlider(String id) {
        super(id);
        this.setType(18);
        this.setValueType(1);
        this.setValue("0");
    }

    public LightUISlider(JSONObject json) {
        super(json);
    }

    public LightUISlider(LightUISlider slider) {
        super(slider);
        this.maxValue = slider.maxValue;
        this.minValue = slider.minValue;
        this.increment = slider.increment;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public Integer getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("max-value", this.maxValue);
        json.put("min-value", this.minValue);
        json.put("increment", this.increment);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.maxValue = JSONConverter.getParameterFromJSON(json, "max-value", Integer.class, 1);
        this.minValue = JSONConverter.getParameterFromJSON(json, "min-value", Integer.class, 0);
        this.increment = JSONConverter.getParameterFromJSON(json, "increment", Integer.class, 1);
    }

    @Override
    public void _setValueFromContext(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Incorrect value " + value + "type for ui element: " + this.getId());
        }
        this.setValue(value.toString());
    }

    @Override
    public Object getValueForContext() {
        if (this.getValue() == null) {
            return null;
        }
        return Integer.parseInt(this.getValue());
    }
}

