/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.HashMap;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.io.JSONConverter;

public class JSONToLightUIConvertorManager {
    HashMap<String, JSONToLightUIConvertor> map = new HashMap();
    private static final JSONToLightUIConvertorManager instance = new JSONToLightUIConvertorManager();

    public static JSONToLightUIConvertorManager getInstance() {
        return instance;
    }

    public void put(String className, JSONToLightUIConvertor convertor) {
        this.map.put(className, convertor);
    }

    public LightUIElement createUIElementFromJSON(JSONObject jsonElement) {
        Integer elementType = JSONConverter.getParameterFromJSON(jsonElement, "type", Integer.class, null);
        if (elementType == null) {
            throw new IllegalArgumentException("LightUIElement must contains attribute 'type'");
        }
        String className = JSONConverter.getParameterFromJSON(jsonElement, "class-name", String.class);
        if (className == null) {
            throw new IllegalArgumentException("class-name must be set");
        }
        JSONToLightUIConvertor convertor = this.map.get(className);
        return convertor.convert(jsonElement);
    }
}

