/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;

public class TimeTextField
extends JTextField {
    public TimeTextField() {
        super(6);
        this.init(0, 0);
    }

    public TimeTextField(boolean fillWithCurrentTime) {
        super(6);
        if (fillWithCurrentTime) {
            Calendar c = Calendar.getInstance();
            this.init(c.get(11), c.get(12));
        } else {
            this.init(0, 0);
        }
    }

    public TimeTextField(int hour, int minute) {
        super(6);
        this.init(hour, minute);
    }

    private void init(int hour, int minute) {
        this.setTime(hour, minute);
        Document d = this.getDocument();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 38) {
                        int caretPosition = TimeTextField.this.getCaretPosition();
                        if (caretPosition < 2) {
                            int i = TimeTextField.this.getHours() + 1;
                            if (i > 23) {
                                i = 0;
                            }
                            String valueOf = TimeTextField.this.fill2Char(i);
                            ((AbstractDocument)TimeTextField.this.getDocument()).replace(0, 2, valueOf, null);
                            TimeTextField.this.setCaretPosition(caretPosition);
                        } else if (caretPosition > 2) {
                            int i = TimeTextField.this.getMinutes() + 1;
                            if (i > 59) {
                                i = 0;
                            }
                            String valueOf = TimeTextField.this.fill2Char(i);
                            ((AbstractDocument)TimeTextField.this.getDocument()).replace(3, 2, valueOf, null);
                            TimeTextField.this.setCaretPosition(caretPosition);
                        }
                    } else if (e.getKeyCode() == 40) {
                        int caretPosition = TimeTextField.this.getCaretPosition();
                        if (caretPosition < 2) {
                            int i = TimeTextField.this.getHours() - 1;
                            if (i < 0) {
                                i = 23;
                            }
                            String valueOf = TimeTextField.this.fill2Char(i);
                            ((AbstractDocument)TimeTextField.this.getDocument()).replace(0, 2, valueOf, null);
                            TimeTextField.this.setCaretPosition(caretPosition);
                        } else if (caretPosition > 2) {
                            int i = TimeTextField.this.getMinutes() - 1;
                            if (i < 0) {
                                i = 59;
                            }
                            String valueOf = TimeTextField.this.fill2Char(i);
                            ((AbstractDocument)TimeTextField.this.getDocument()).replace(3, 2, valueOf, null);
                            TimeTextField.this.setCaretPosition(caretPosition);
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        final AbstractDocument doc = (AbstractDocument)d;
        doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                if (offset == 2) {
                    --offset;
                }
                super.replace(fb, offset + 1, 0, "0", null);
                super.remove(fb, offset, 1);
                TimeTextField.this.setCaretPosition(offset);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                int position;
                if (offset > 4) {
                    return;
                }
                String actualText = doc.getText(0, 5);
                if (length > 0 && text.length() != length) {
                    length = 0;
                }
                char[] te = actualText.toCharArray();
                int stop = text.length();
                int i = 0;
                while (i < stop) {
                    position = i + offset;
                    te[position] = text.charAt(i);
                    ++i;
                }
                i = 0;
                while (i < stop) {
                    position = i + offset;
                    char c = text.charAt(i);
                    if (!TimeTextField.this.isCharValid(c, position, te)) {
                        return;
                    }
                    ++i;
                }
                if (length == 0) {
                    super.remove(fb, offset, text.length());
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
        this.setNavigationFilter(new NavigationFilter(){

            @Override
            public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                if (pos == 1 && direction == 3) {
                    ++pos;
                }
                if (pos == 3 && direction == 7) {
                    --pos;
                }
                return super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
            }

            @Override
            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                if (dot == 2) {
                    dot = 3;
                }
                super.moveDot(fb, dot, bias);
            }

            @Override
            public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                if (dot == 2) {
                    dot = 3;
                }
                super.setDot(fb, dot, bias);
            }
        });
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (TimeTextField.this.getText().length() == 5) {
                    TimeTextField.this.firePropertyChange("value", null, TimeTextField.this.getText());
                }
            }
        });
    }

    public void setTime(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be betwen 0 and 23 but is " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be betwen 0 and 59 but is " + minute);
        }
        String s = "";
        if (hour < 10) {
            s = String.valueOf(s) + "0";
        }
        s = String.valueOf(s) + hour + ":";
        if (minute < 10) {
            s = String.valueOf(s) + "0";
        }
        s = String.valueOf(s) + minute;
        this.setText(s);
    }

    public int getHours() {
        String s = this.getText().substring(0, 2);
        return Integer.parseInt(s);
    }

    public int getMinutes() {
        String s = this.getText().substring(3, 5);
        return Integer.parseInt(s);
    }

    protected String fill2Char(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    @Override
    public void setCaretPosition(int position) {
        if (position == 2) {
            ++position;
        }
        super.setCaretPosition(position);
    }

    public boolean isCharValid(char c, int position, char[] actualText) {
        switch (position) {
            case 0: {
                if (c >= '0' && c <= '1') {
                    return true;
                }
                char c1 = actualText[1];
                if (c != '2' || c1 > '3') break;
                return true;
            }
            case 1: {
                if (c >= '0' && c <= '3') {
                    return true;
                }
                char c0 = actualText[0];
                if (c < '4' || c > '9' || c0 != '0' && c0 != '1') break;
                return true;
            }
            case 2: {
                if (c != ':') break;
                return true;
            }
            case 3: {
                if (c < '0' || c > '5') break;
                return true;
            }
            case 4: {
                if (c < '0' || c > '9') break;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        TimeTextField time = new TimeTextField(true);
        time.setTime(10, 59);
        f.setContentPane(time);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

