/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import org.jopencalendar.ui.DatePicker;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.i18n.TM;

public final class JDate
extends JComponent
implements InteractionMode.InteractionComponent,
TextComponent,
ValueWrapper<Date> {
    private static boolean CommitEachValidEditDefault;
    public static String DATE_PICKER_FORMATS_KEY;
    private final boolean fillWithCurrentDate;
    private final boolean commitEachValidEdit;
    private final Calendar cal;
    private final DatePicker picker;

    static {
        String formats;
        CommitEachValidEditDefault = false;
        DATE_PICKER_FORMATS_KEY = "org.openconcerto.DatePicker.formats";
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        if (lafDefaults.get(DATE_PICKER_FORMATS_KEY) == null && (formats = TM.getInstance().translate(TM.MissingMode.NULL, "jdate.formats", new Object[0])) != null && formats.trim().length() > 0) {
            String[] array = formats.split("\n");
            lafDefaults.put(DATE_PICKER_FORMATS_KEY, array);
        }
    }

    static DateFormat[] getDefaultDateFormats() {
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        String[] formats = (String[])lafDefaults.get(DATE_PICKER_FORMATS_KEY);
        if (formats == null || formats.length == 0) {
            return new DateFormat[]{DateFormat.getDateInstance()};
        }
        DateFormat[] l = new DateFormat[formats.length];
        int i = 0;
        while (i < l.length) {
            l[i] = new SimpleDateFormat(formats[i]);
            ++i;
        }
        return l;
    }

    static Format getDefaultDateFormat() {
        Format[] formats = JDate.getDefaultDateFormats();
        if (formats.length == 1) {
            return formats[0];
        }
        return new FormatGroup(formats);
    }

    public static void setCommitEachValidEditDefault(boolean commitEachValidEditDefault) {
        CommitEachValidEditDefault = commitEachValidEditDefault;
    }

    public static boolean getCommitEachValidEditDefault() {
        return CommitEachValidEditDefault;
    }

    public JDate() {
        this(false);
    }

    public JDate(boolean fillWithCurrentDate) {
        this(fillWithCurrentDate, JDate.getCommitEachValidEditDefault());
    }

    public JDate(boolean fillWithCurrentDate, boolean commitEachValidEdit) {
        this.setLayout(new GridLayout(1, 1));
        this.picker = new DatePicker(JDate.getDefaultDateFormat(), true, false);
        this.add((Component)this.picker);
        this.setMinimumSize(new Dimension(this.picker.getPreferredSize()));
        this.fillWithCurrentDate = fillWithCurrentDate;
        if (commitEachValidEdit) {
            Log.get().warning("commitEachValidEdit ignored due to Java bug");
        }
        this.commitEachValidEdit = false;
        InputMap inputMap = this.getEditor().getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "dayToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "dayToPast");
        inputMap.put(KeyStroke.getKeyStroke(38, 512), "monthToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 512), "monthToPast");
        ActionMap actionMap = this.getEditor().getActionMap();
        this.cal = Calendar.getInstance();
        actionMap.put("dayToPast", this.createChangeDateAction(6, -1));
        actionMap.put("dayToFuture", this.createChangeDateAction(6, 1));
        actionMap.put("monthToPast", this.createChangeDateAction(2, -1));
        actionMap.put("monthToFuture", this.createChangeDateAction(2, 1));
        this.updateUI();
        this.resetValue();
    }

    private JFormattedTextField getEditor() {
        return this.picker.getEditor();
    }

    public final boolean fillsWithCurrentDate() {
        return this.fillWithCurrentDate;
    }

    protected final Calendar getCal() {
        return this.cal;
    }

    protected AbstractAction createChangeDateAction(final int field, final int amount) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent comp = (JTextComponent)e.getSource();
                if (!comp.isEnabled() || !comp.isEditable()) {
                    return;
                }
                Date currentVal = JDate.this.getDate();
                if (currentVal == null && JDate.this.fillsWithCurrentDate()) {
                    currentVal = new Date();
                }
                if (currentVal != null) {
                    JDate.this.getCal().setTime(currentVal);
                    JDate.this.getCal().add(field, amount);
                    JDate.this.setValue(JDate.this.getCal().getTime());
                }
            }
        };
    }

    public void setFormats(DateFormat[] formats) {
        this.setFormatP(new FormatGroup(formats));
    }

    public void setFormat(DateFormat format) {
        this.setFormatP(format);
    }

    private void setFormatP(Format format) {
        InternationalFormatter formatter = new InternationalFormatter(format){

            @Override
            public Object stringToValue(String text) throws ParseException {
                Object result = text == null || text.isEmpty() ? null : super.stringToValue(text);
                return result;
            }
        };
        formatter.setCommitsOnValidEdit(this.commitEachValidEdit);
        this.getEditor().setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory = this.getEditor().getFormatterFactory();
        if (factory != null && (formatter = factory.getFormatter(this.getEditor())) instanceof InternationalFormatter) {
            Format format = ((InternationalFormatter)formatter).getFormat();
            if (format instanceof DateFormat) {
                return new DateFormat[]{(DateFormat)format};
            }
            if (format instanceof FormatGroup) {
                ArrayList<? extends Format> formats = new ArrayList<Format>(((FormatGroup)format).getFormats());
                Iterator iter = formats.iterator();
                while (iter.hasNext()) {
                    Format element = (Format)iter.next();
                    if (element instanceof DateFormat) continue;
                    iter.remove();
                }
                return formats.toArray(new DateFormat[formats.size()]);
            }
        }
        return null;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFormats(JDate.getDefaultDateFormats());
    }

    @Override
    public final void resetValue() {
        if (this.fillsWithCurrentDate()) {
            this.setValue(new Date());
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date date) {
        Date timeless;
        if (date == null) {
            timeless = null;
        } else {
            this.getCal().setTime(date);
            TimeUtils.clearTime(this.getCal());
            timeless = this.getCal().getTime();
        }
        this.setDate(timeless);
    }

    @Override
    public final Date getValue() {
        return this.getDate();
    }

    public final boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.getEditor().removePropertyChangeListener("value", l);
    }

    public void commitEdit() throws ParseException {
        this.picker.commitEdit();
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }

    public void setDate(Date date) {
        this.picker.setDate(date);
    }

    public void setDateInMillis(long millis) {
        this.picker.setDate(new Date(millis));
    }

    public Date getDate() {
        return this.picker.getDate();
    }

    public long getDateInMillis() {
        return this.picker.getDate().getTime();
    }

    @Override
    public void setInteractionMode(InteractionMode mode) {
        this.picker.setEditable(mode.isEditable());
        this.setEnabled(mode.isEnabled());
    }

    @Override
    public InteractionMode getInteractionMode() {
        return InteractionMode.from(this.picker.isEnabled(), this.picker.isEditable());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.picker.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void addActionListener(ActionListener actionListener) {
        this.picker.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.picker.removeActionListener(actionListener);
    }

    public void setButtonVisible(boolean b) {
        this.picker.setButtonVisible(b);
    }
}

