/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.view.search.ColumnSearchSpec;
import org.openconcerto.sql.view.search.EmptySearchSpec;
import org.openconcerto.sql.view.search.SearchListComponent;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.sql.view.search.TextSearchSpec;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SearchItemComponent
extends JPanel {
    private static final Column TOUT = new Column(TM.tr("all", new Object[0]), null, -1);
    private static final TextSearchSpec.Mode[] MODES = new TextSearchSpec.Mode[]{TextSearchSpec.Mode.CONTAINS, TextSearchSpec.Mode.CONTAINS_STRICT, TextSearchSpec.Mode.LESS_THAN, TextSearchSpec.Mode.EQUALS, TextSearchSpec.Mode.EQUALS_STRICT, TextSearchSpec.Mode.GREATER_THAN};
    private JTextField textFieldRecherche = new JTextField(10);
    private final JComboBox comboColonnePourRecherche;
    private final JComboBox searchMode;
    private JCheckBox invertSearch = new JCheckBox(TM.tr("toReverse", new Object[0]));
    private JButton buttonAdd = new JButton("+");
    private JButton buttonRemove = new JButton();
    final SearchListComponent list;
    private String text = "";

    public SearchItemComponent(SearchListComponent list) {
        this.list = list;
        this.setOpaque(false);
        this.searchMode = new JComboBox<String>(new String[]{TM.tr("contains", new Object[0]), TM.tr("contains.exactly", new Object[0]), TM.tr("isLessThan", new Object[0]), TM.tr("isEqualTo", new Object[0]), TM.tr("isExactlyEqualTo", new Object[0]), TM.tr("isGreaterThan", new Object[0]), TM.tr("isEmpty", new Object[0])});
        ListComboBoxModel<Column> comboModel = new ListComboBoxModel<Column>(Arrays.asList(TOUT));
        comboModel.setSelectOnAdd(false);
        assert (comboModel.getSelectedItem() != null);
        this.comboColonnePourRecherche = new JComboBox<Column>(comboModel);
        this.uiInit();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        final ListCellRenderer old = this.comboColonnePourRecherche.getRenderer();
        this.comboColonnePourRecherche.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return old.getListCellRendererComponent(list, ((Column)value).getLabel(), index, isSelected, cellHasFocus);
            }
        });
        this.comboColonnePourRecherche.setMinimumSize(new Dimension(150, 20));
        this.comboColonnePourRecherche.setOpaque(false);
        this.add((Component)this.comboColonnePourRecherche, c);
        ++c.gridx;
        this.searchMode.setMinimumSize(new Dimension(40, 20));
        this.searchMode.setOpaque(false);
        this.add((Component)this.searchMode, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textFieldRecherche.setMinimumSize(new Dimension(50, 20));
        this.add((Component)this.textFieldRecherche, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.invertSearch.setOpaque(false);
        if (!Boolean.getBoolean("org.openconcerto.ui.removeSwapSearchCheckBox")) {
            this.add((Component)this.invertSearch, c);
        }
        ++c.gridx;
        this.buttonAdd.setOpaque(false);
        this.add((Component)this.buttonAdd, c);
        ++c.gridx;
        this.buttonRemove.setIcon(new ImageIcon(BaseSQLComponent.class.getResource("delete.png")));
        this.buttonRemove.setBorder(BorderFactory.createEmptyBorder());
        this.buttonRemove.setOpaque(false);
        this.buttonRemove.setBorderPainted(false);
        this.buttonRemove.setFocusPainted(false);
        this.buttonRemove.setContentAreaFilled(false);
        this.add((Component)this.buttonRemove, c);
        this.initCombo();
        this.initSearchText();
        this.initInvertSearch();
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.list.addNewSearchItem();
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.list.removeSearchItem(SearchItemComponent.this);
            }
        });
    }

    private void initInvertSearch() {
        this.invertSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.updateSearchList();
            }
        });
    }

    private void initSearchText() {
        this.textFieldRecherche.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                try {
                    SearchItemComponent.this.text = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    SearchItemComponent.this.updateSearchList();
                }
                catch (BadLocationException exn) {
                    exn.printStackTrace();
                }
            }
        });
    }

    private void initCombo() {
        final ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchItemComponent.this.updateSearchList();
            }
        };
        this.searchMode.addItemListener(listener);
        final TableModelListener tableModelL = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == -1 && e.getFirstRow() == -1) {
                    SearchItemComponent.this.columnsChanged(listener);
                }
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (e.getChanged().isDisplayable()) {
                        SearchItemComponent.this.columnsChanged(listener);
                        SearchItemComponent.this.list.getTableModel().addTableModelListener(tableModelL);
                    } else {
                        SearchItemComponent.this.list.getTableModel().removeTableModelListener(tableModelL);
                    }
                }
            }
        });
        assert (!this.isDisplayable());
    }

    private void selectAllColumnsItem() {
        this.comboColonnePourRecherche.setSelectedIndex(0);
    }

    private void fillColumnCombo(ItemListener listener) {
        int columnCount = this.list.getTableModel().getColumnCount();
        String[][] names = new String[columnCount][];
        int[] indexes = new int[columnCount];
        int i = 0;
        while (i < columnCount) {
            names[i] = this.list.getColumnNames(i);
            indexes[i] = 0;
            ++i;
        }
        SortedMap<String, Integer> map = this.solve(names, indexes);
        ArrayList<Column> cols = new ArrayList<Column>(columnCount);
        cols.add(TOUT);
        for (Map.Entry<String, Integer> e : map.entrySet()) {
            int colIndex = e.getValue();
            String[] colNames = names[colIndex];
            cols.add(new Column(e.getKey(), colNames[colNames.length - 1], colIndex));
        }
        this.comboColonnePourRecherche.removeItemListener(listener);
        ListComboBoxModel comboModel = (ListComboBoxModel)this.comboColonnePourRecherche.getModel();
        assert (!comboModel.isSelectOnAdd()) : "Otherwise our following select might not fire";
        comboModel.removeAllElements();
        comboModel.addAll(cols);
        this.comboColonnePourRecherche.addItemListener(listener);
    }

    private void columnsChanged(ItemListener listener) {
        String currentID = ((Column)this.comboColonnePourRecherche.getSelectedItem()).getID();
        this.fillColumnCombo(listener);
        ListComboBoxModel comboModel = (ListComboBoxModel)this.comboColonnePourRecherche.getModel();
        assert (this.comboColonnePourRecherche.getSelectedIndex() == -1 && this.comboColonnePourRecherche.getSelectedItem() == null);
        for (Object o : comboModel.getList()) {
            Column col = (Column)o;
            if (!CompareUtils.equals(col.getID(), currentID)) continue;
            this.comboColonnePourRecherche.setSelectedItem(o);
        }
        if (comboModel.getSelectedItem() == null) {
            this.selectAllColumnsItem();
        }
    }

    private SortedMap<String, Integer> solve(String[][] names, int[] indexes) {
        int columnCount = names.length;
        ListMap<String, Integer> collisions = new ListMap<String, Integer>(columnCount);
        int i = 0;
        while (i < columnCount) {
            int index = indexes[i];
            if (index >= names[i].length) {
                throw new IllegalStateException("Ran out of names for " + i + " : " + Arrays.asList(names[i]));
            }
            String columnName = names[i][index];
            collisions.add(columnName, i);
            ++i;
        }
        TreeMap<String, Integer> res = new TreeMap<String, Integer>();
        for (Map.Entry e : collisions.entrySet()) {
            Collection indexesWithCollision = (Collection)e.getValue();
            if (indexesWithCollision.size() > 1) {
                int minIndex = Integer.MAX_VALUE;
                for (Integer i2 : indexesWithCollision) {
                    if (indexes[i2] >= minIndex) continue;
                    minIndex = indexes[i2];
                }
                for (Integer i2 : indexesWithCollision) {
                    if (indexes[i2] != minIndex) continue;
                    int n = i2;
                    indexes[n] = indexes[n] + 1;
                }
                continue;
            }
            res.put((String)e.getKey(), (Integer)indexesWithCollision.iterator().next());
        }
        if (res.size() == columnCount) {
            return res;
        }
        return this.solve(names, indexes);
    }

    void updateSearchList() {
        this.list.updateSearch();
    }

    public SearchSpec getSearchItem() {
        SearchSpec res;
        if (this.searchMode.getSelectedIndex() < MODES.length) {
            TextSearchSpec textSpec = new TextSearchSpec(this.getText(), MODES[this.searchMode.getSelectedIndex()]);
            textSpec.setFormats(this.list.getFormats());
            res = textSpec;
        } else {
            res = new EmptySearchSpec();
        }
        return new ColumnSearchSpec(this.isExcluded(), res, this.getColIndex());
    }

    private final boolean isExcluded() {
        return this.invertSearch.isSelected();
    }

    private final int getColIndex() {
        return ((Column)this.comboColonnePourRecherche.getSelectedItem()).getIndex();
    }

    private final String getText() {
        return this.text;
    }

    public final void setText(String s) {
        this.textFieldRecherche.setText(s);
    }

    public void resetState() {
        this.setText("");
        this.selectAllColumnsItem();
        this.searchMode.setSelectedIndex(0);
        this.invertSearch.setSelected(false);
    }

    public void setSearchFullMode(boolean b) {
        this.invertSearch.setVisible(b);
        this.buttonAdd.setVisible(b);
        this.buttonRemove.setVisible(b);
        this.comboColonnePourRecherche.setVisible(b);
        this.searchMode.setVisible(b);
    }

    protected static final class Column {
        private final String label;
        private final String id;
        private final int index;

        protected Column(String label, String id, int index) {
            this.label = label;
            this.id = id;
            this.index = index;
        }

        public final String getLabel() {
            return this.label;
        }

        public final String getID() {
            return this.id;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

