/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.openconcerto.sql.view.list.VirtualMenu;

class VirtualMenuGroup {
    private final VirtualMenu parent;
    private final String name;
    private final List<Item> items;
    private final Map<String, VirtualMenu> menus;

    VirtualMenuGroup(VirtualMenu parent, String name) {
        if (parent == null) {
            throw new NullPointerException("Null parent");
        }
        this.parent = parent;
        this.name = name;
        this.items = new ArrayList<Item>();
        this.menus = new LinkedHashMap<String, VirtualMenu>();
    }

    public final String getName() {
        return this.name;
    }

    public final VirtualMenu getParentMenu() {
        return this.parent;
    }

    public final List<String> getPath() {
        List<String> res = this.getParentMenu().getPath();
        res.add(this.getName());
        return res;
    }

    public final int getItemCount() {
        return this.items.size();
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public final void add(JMenuItem mi) {
        this.add(new LeafItem(this, mi));
    }

    public final void add(Item item) {
        this.items.add(item);
        item.setParentGroup(this);
        if (item instanceof VirtualMenu) {
            VirtualMenu menu = (VirtualMenu)item;
            this.menus.put(menu.getName(), menu);
        }
    }

    public final void addAll(List<Item> items) {
        for (Item item : items) {
            this.add(item);
        }
    }

    void merge(VirtualMenuGroup g) {
        for (Item item : g.items) {
            if (!(item instanceof VirtualMenu)) {
                this.add(item);
                continue;
            }
            if (this.menus.containsKey(item.getName())) {
                this.menus.get(item.getName()).merge((VirtualMenu)item);
                continue;
            }
            this.add(item);
        }
    }

    public final void remove(Item item) {
        this.items.remove(item);
        item.setParentGroup(null);
        if (item instanceof VirtualMenu) {
            this.menus.remove(((VirtualMenu)item).getName());
        }
    }

    protected final VirtualMenu getMenu(String name) {
        VirtualMenu res = this.menus.get(name);
        if (res == null) {
            res = VirtualMenu.createFromParentMenu(this, name);
            this.add(res);
        }
        return res;
    }

    public final Map<String, VirtualMenu> getMenus() {
        return Collections.unmodifiableMap(this.menus);
    }

    static abstract class Item {
        private VirtualMenuGroup parent;

        protected Item(VirtualMenuGroup parent) {
            this.setParentGroup(parent);
        }

        final void setParentGroup(VirtualMenuGroup parent) {
            this.parent = parent;
        }

        final VirtualMenuGroup getParentGroup() {
            return this.parent;
        }

        protected abstract String getName();

        abstract List<String> getPath();

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
        }
    }

    static class LeafItem
    extends Item {
        private final JMenuItem mi;

        LeafItem(VirtualMenuGroup parent, JMenuItem mi) {
            super(parent);
            this.mi = mi;
        }

        final JMenuItem getJMenuItem() {
            return this.mi;
        }

        @Override
        protected String getName() {
            return this.getJMenuItem().getText();
        }

        @Override
        final List<String> getPath() {
            return this.getParentGroup().getPath();
        }
    }
}

