/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.MoveQueue;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.Value;

public class SQLTableModelLinesSourceOnline
extends SQLTableModelLinesSource {
    private final SQLTableModelSourceOnline parent;
    private final PropertyChangeListener listener;
    private MoveQueue moveQ;

    public SQLTableModelLinesSourceOnline(SQLTableModelSourceOnline parent, ITableModel model) {
        super(model);
        this.parent = parent;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLTableModelLinesSourceOnline.this.fireChanged(evt);
            }
        };
        this.getParent().getReq().addWhereListener(this.listener);
        this.moveQ = null;
    }

    MoveQueue getMoveQ() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.moveQ == null) {
            this.moveQ = new MoveQueue(this.getModel());
            this.moveQ.start();
        }
        return this.moveQ;
    }

    @Override
    protected void die() {
        this.getParent().getReq().rmWhereListener(this.listener);
        if (this.moveQ != null) {
            SleepingQueue.RunningState threadState = this.moveQ.getRunningState();
            if (threadState == SleepingQueue.RunningState.RUNNING) {
                SleepingQueue.LethalFutureTask<?> dieMove = this.moveQ.die();
                this.getModel().wait(dieMove, 15L, TimeUnit.MILLISECONDS);
            } else {
                Log.get().warning("Not dying since queue is " + (Object)((Object)threadState));
            }
        }
        super.die();
    }

    @Override
    public final SQLTableModelSourceOnline getParent() {
        return this.parent;
    }

    @Override
    public List<ListSQLLine> getAll() {
        List<SQLRowValues> values = this.getUpdateQueueReq().getValues();
        ArrayList<ListSQLLine> res = new ArrayList<ListSQLLine>(values.size());
        for (SQLRowValues v : values) {
            ListSQLLine newLine = this.createLine(v);
            if (newLine == null) continue;
            res.add(newLine);
        }
        return res;
    }

    @Override
    public Value<ListSQLLine> get(int id) {
        return Value.getSome(this.createLine(this.getUpdateQueueReq().getValues(id)));
    }

    private BigDecimal getOrder(SQLRowAccessor r) {
        return (BigDecimal)r.getObject(r.getTable().getOrderField().getName());
    }

    @Override
    public int compare(ListSQLLine l1, ListSQLLine l2) {
        return this.getOrder(l1.getRow()).compareTo(this.getOrder(l2.getRow()));
    }

    @Override
    public Future<?> moveBy(List<? extends SQLRowAccessor> rows, int inc) {
        return this.getMoveQ().move(rows, inc);
    }

    @Override
    public Future<?> moveTo(List<? extends Number> rows, int rowIndex) {
        return this.getMoveQ().moveTo(rows, rowIndex);
    }

    @Override
    public void commit(ListSQLLine l, Path path, SQLRowValues vals) throws SQLException {
        vals.update();
    }
}

