/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.view.list.SQLTableModelColumn;

public final class SQLTableModelColumns {
    private static final SQLTableModelColumns EMPTY = new SQLTableModelColumns();
    private final List<SQLTableModelColumn> cols;
    private final List<SQLTableModelColumn> allCols;

    public static final SQLTableModelColumns empty() {
        return EMPTY;
    }

    public SQLTableModelColumns(List<SQLTableModelColumn> cols, List<SQLTableModelColumn> debugCols) {
        this.cols = Collections.unmodifiableList(new ArrayList<SQLTableModelColumn>(cols));
        ArrayList<SQLTableModelColumn> tmp = new ArrayList<SQLTableModelColumn>(cols.size() + debugCols.size());
        tmp.addAll(cols);
        tmp.addAll(debugCols);
        this.allCols = Collections.unmodifiableList(tmp);
    }

    private SQLTableModelColumns() {
        this.cols = Collections.emptyList();
        this.allCols = Collections.emptyList();
    }

    public final List<SQLTableModelColumn> getColumns() {
        return this.cols;
    }

    public final List<SQLTableModelColumn> getAllColumns() {
        return this.allCols;
    }

    public int size() {
        return this.allCols.size();
    }

    public final List<SQLTableModelColumn> getColumns(SQLField f) {
        ArrayList<SQLTableModelColumn> res = new ArrayList<SQLTableModelColumn>();
        for (SQLTableModelColumn col : this.getColumns()) {
            if (!col.getFields().contains(f)) continue;
            res.add(col);
        }
        return res;
    }

    public final SQLTableModelColumn getColumn(SQLField f) {
        Set<SQLField> singleton = Collections.singleton(f);
        SQLTableModelColumn res = null;
        for (SQLTableModelColumn col : this.getColumns()) {
            if (!col.getFields().equals(singleton)) continue;
            if (res == null) {
                res = col;
                continue;
            }
            throw new IllegalArgumentException("Not exactly one column for " + f);
        }
        return res;
    }

    public final SQLTableModelColumn getColumn(FieldPath fp) {
        Set<FieldPath> singleton = Collections.singleton(fp);
        SQLTableModelColumn res = null;
        for (SQLTableModelColumn col : this.getColumns()) {
            if (!col.getPaths().equals(singleton)) continue;
            if (res == null) {
                res = col;
                continue;
            }
            throw new IllegalArgumentException("Not exactly one column for " + fp);
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        return 31 + this.allCols.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLTableModelColumns other = (SQLTableModelColumns)obj;
        return this.allCols.equals(other.allCols);
    }
}

