/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;

public class SQLCreateTable
extends SQLCreateTableBase<SQLCreateTable> {
    private final DBRoot b;
    private boolean createID;
    private boolean createOrder;
    private boolean createArchive;
    private List<String> orderConstraintFields;

    public SQLCreateTable(DBRoot b, String name) {
        super(b.getDBSystemRoot().getSyntax(), b.getName(), name);
        this.b = b;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.setPlain(false);
        this.orderConstraintFields = Collections.singletonList("ORDRE");
    }

    public final DBRoot getRoot() {
        return this.b;
    }

    public final void setPlain(boolean b) {
        this.setCreateID(!b);
        this.setCreateOrder(!b);
        this.setCreateArchive(!b);
    }

    public final boolean isCreateID() {
        return this.createID;
    }

    public final void setCreateID(boolean createID) {
        this.createID = createID;
    }

    public final boolean isCreateOrder() {
        return this.createOrder;
    }

    public final void setCreateOrder(boolean createOrder) {
        this.createOrder = createOrder;
    }

    public final void setOrderConstraintFields(Collection<String> fields) {
        ArrayList<String> list;
        LinkedHashSet<String> set = new LinkedHashSet<String>(fields);
        if (!set.contains("ORDRE")) {
            list = new ArrayList(set.size() + 1);
            list.add("ORDRE");
            list.addAll(set);
        } else {
            list = new ArrayList<String>(set);
        }
        this.orderConstraintFields = Collections.unmodifiableList(list);
    }

    public final boolean isCreateArchive() {
        return this.createArchive;
    }

    public final void setCreateArchive(boolean createArchive) {
        this.createArchive = createArchive;
    }

    public SQLCreateTable addForeignColumn(String foreignTable) {
        return this.addForeignColumn(foreignTable, "");
    }

    public SQLCreateTable addForeignColumn(String foreignTableN, String suffix) {
        String fk = "ID_" + foreignTableN + (suffix.length() == 0 ? "" : "_" + suffix);
        SQLTable foreignTable = this.b.getTable(foreignTableN);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Unknown table in " + this.b + " : " + foreignTableN);
        }
        return (SQLCreateTable)this.addForeignColumn(fk, foreignTable, true);
    }

    @Override
    public List<String> getPrimaryKey() {
        return !this.isCreateID() ? super.getPrimaryKey() : Collections.singletonList("ID");
    }

    @Override
    protected void checkPK() {
        if (this.isCreateID()) {
            throw new IllegalStateException("can only set primary key in plain mode, otherwise it is automatically added");
        }
    }

    @Override
    protected void modifyClauses(ChangeTable.InAndOutClauses res) {
        super.modifyClauses(res);
        if (this.isCreateID()) {
            res.getInClauses().addClause(0, String.valueOf(SQLBase.quoteIdentifier("ID")) + this.getSyntax().getPrimaryIDDefinition(), ChangeTable.ClauseType.ADD_COL);
        }
        if (this.isCreateArchive()) {
            res.getInClauses().addClause(String.valueOf(SQLBase.quoteIdentifier("ARCHIVE")) + this.getSyntax().getArchiveDefinition(), ChangeTable.ClauseType.ADD_COL);
        }
        if (this.isCreateOrder()) {
            res.getInClauses().addClause(String.valueOf(SQLBase.quoteIdentifier("ORDRE")) + this.getSyntax().getOrderDefinition(false), ChangeTable.ClauseType.ADD_COL);
            if (this.getSyntax().getSystem() == SQLSystem.MSSQL) {
                res.getOutClauses().addClause(this.createUniquePartialIndex("orderIdx", this.orderConstraintFields, null));
            } else {
                res.getInClauses().addClause(this.createUniqueConstraint("orderUniq", this.orderConstraintFields));
            }
        }
    }
}

