/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.utils.MySQLXML2;
import org.openconcerto.utils.cc.IClosure;

public class MySQL2Postgresql
extends MySQLXML2 {
    public static void main(String[] args) throws JDOMException, IOException {
        File xmlFile = new File(args[0]);
        new MySQL2Postgresql().convert(xmlFile);
    }

    public MySQL2Postgresql() {
        super(SQLSystem.POSTGRESQL.getSyntax());
    }

    @Override
    public void fixXML(Document doc) throws JDOMException {
        super.fixXML(doc);
        this.fixAttr(doc, "Type", "starts-with", "tinyint(1)", new IClosure<Element>(){

            @Override
            public void executeChecked(Element fieldElem) {
                fieldElem.setAttribute("Type", "boolean");
                String mysqlDef = fieldElem.getAttributeValue("Default");
                if (mysqlDef != null) {
                    fieldElem.setAttribute("Default", mysqlDef.equals("0") ? "false" : "true");
                }
            }
        });
        this.fixAttr(doc, "Default", "contains", "0000-00-00", new IClosure<Element>(){

            @Override
            public void executeChecked(Element fieldElem) {
                fieldElem.removeAttribute("Default");
            }
        });
        this.fixAutoIncrement(doc);
    }

    private void fixAutoIncrement(Document doc) throws JDOMException {
        this.fixAttr(doc, "Extra", "contains", "auto_increment", new IClosure<Element>(){

            @Override
            public void executeChecked(Element fieldElem) {
                fieldElem.setAttribute("Type", "serial");
                fieldElem.setAttribute("Extra", "");
            }
        });
    }
}

