/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import org.openconcerto.sql.model.SQLRowAccessor;

public final class User {
    private final int id;
    private final String name;
    private final String firstName;
    private final String nickName;
    private final Boolean active;

    public User(SQLRowAccessor r) {
        this.id = r.getID();
        this.name = r.getString("NOM").trim();
        this.firstName = r.getString("PRENOM").trim();
        this.nickName = r.getString("SURNOM").trim();
        this.active = r.getFields().contains("DISABLED") ? Boolean.valueOf(r.getBoolean("DISABLED") == false) : null;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.getFullName()) + " /" + this.getId();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getFullName() {
        return String.valueOf(this.getFirstName()) + " " + this.getName();
    }

    public boolean isActive() {
        return this.active;
    }
}

