/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject.itemview;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;

public abstract class BaseRowItemView
implements MutableRowItemView {
    private final List<SQLField> fields = new ArrayList<SQLField>();
    private String sqlName;

    public static final <T> T getOnlyOne(List<T> l) {
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new IllegalStateException("More than one : " + l);
        }
        return l.get(0);
    }

    @Override
    public final void init(String sqlName, Set<SQLField> fields) {
        this.sqlName = sqlName;
        this.fields.addAll(fields);
        this.init();
        if (this.getComp() instanceof RowItemViewComponent) {
            ((RowItemViewComponent)((Object)this.getComp())).init(this);
        }
    }

    protected abstract void init();

    @Override
    public final List<SQLField> getFields() {
        return this.fields;
    }

    @Override
    public final SQLField getField() {
        return BaseRowItemView.getOnlyOne(this.fields);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getFields();
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.update(vals);
    }

    @Override
    public final String getSQLName() {
        return this.sqlName;
    }
}

