/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject.animated;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class AnimatedTextField
extends JTextField {
    private boolean isAnimating = false;

    public AnimatedTextField() {
        this(12);
    }

    public AnimatedTextField(int columns) {
        super(columns);
        this.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                AnimatedTextField.this.startOrStop();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AnimatedTextField.this.startOrStop();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                AnimatedTextField.this.stopAnimation();
            }
        });
    }

    public void stopAnimation() {
        this.setAnimating(false);
    }

    public void startAnimation() {
        this.setAnimating(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int[] nArray = new int[26];
                nArray[2] = 64;
                nArray[3] = 80;
                nArray[4] = 160;
                nArray[5] = 255;
                nArray[6] = 255;
                nArray[7] = 160;
                nArray[8] = 64;
                nArray[9] = 1;
                nArray[10] = 1;
                nArray[11] = 64;
                nArray[12] = 80;
                nArray[13] = 160;
                nArray[14] = 255;
                nArray[15] = 218;
                nArray[16] = 160;
                nArray[17] = 64;
                int[] a = nArray;
                int i = 0;
                while (AnimatedTextField.this.isAnimating()) {
                    if (++i >= a.length) {
                        i = 0;
                    }
                    try {
                        Thread.sleep(200L);
                        final int currentColor = a[i];
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AnimatedTextField.this.setBackground(new Color(255, 255, 255 - currentColor / 4));
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AnimatedTextField.this.setBackground(Color.WHITE);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void startOrStop() {
        if (this.getText().length() > 0) {
            this.stopAnimation();
        } else if (!this.isAnimating()) {
            this.startAnimation();
        }
    }

    synchronized void setAnimating(boolean isAnimating) {
        this.isAnimating = isAnimating;
    }

    synchronized boolean isAnimating() {
        return this.isAnimating;
    }
}

