/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.sql.view.search.SearchSpecUtils;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.component.combo.Log;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.ISearchable;
import org.openconcerto.utils.model.NewSelection;

public class IComboModel
extends DefaultIMutableListModel<IComboSelectionItem>
implements SQLTableModifiedListener,
EmptyObj,
MutableValueObject<IComboSelectionItem>,
ISearchable {
    private final ComboSQLRequest req;
    protected Integer nonDBCount = 0;
    private List<IComboSelectionItem> nonDBItems = Collections.emptyList();
    private boolean filledOnce = false;
    private ITransformer<List<IComboSelectionItem>, IComboSelectionItem> firstFillTransf = null;
    private boolean isADirtyDrityGirl;
    private boolean sleepAllowed = true;
    private int requestDelay = 50;
    private final EmptyChangeSupport emptySupp;
    private final PropertyChangeSupport propSupp;
    private SwingWorker<?, ?> willUpdate;
    private FillMode willUpdateMode;
    protected final List<Runnable> runnables;
    private boolean updating;
    private int idToSelect;
    private Map<Integer, IComboSelectionItem> itemsByID;
    private SearchSpec search;
    private final boolean reqSearchable;
    private List<String> searchQuery;
    private Where searchForceInclude;
    private PropertyChangeListener filterListener;
    private ITableModel.SleepState sleepState;
    private boolean debug = false;
    private boolean addMissingItem;
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("\\s+");

    public IComboModel(ComboSQLRequest req) {
        this(req, req.isSearchable());
    }

    public IComboModel(ComboSQLRequest req, boolean reqSearchable) {
        if (req == null) {
            throw new NullPointerException("null request");
        }
        this.req = req;
        this.emptySupp = new EmptyChangeSupport(this);
        this.propSupp = new PropertyChangeSupport(this);
        this.idToSelect = -1;
        this.search = null;
        this.reqSearchable = reqSearchable;
        this.searchQuery = Collections.emptyList();
        this.searchForceInclude = null;
        this.runnables = new ArrayList<Runnable>();
        this.willUpdate = null;
        this.updating = false;
        this.itemsByID = new HashMap<Integer, IComboSelectionItem>();
        this.addMissingItem = true;
        this.sleepState = ITableModel.SleepState.HIBERNATING;
        this.isADirtyDrityGirl = true;
        this.setSelectOnAdd(false);
        this.setOnReplacingSelection(NewSelection.NO);
        this.setOnRemovingSelection(NewSelection.NONE);
        this.uiInit();
    }

    public final boolean neverBeenFilled() {
        return !this.filledOnce;
    }

    private final ITransformer<List<IComboSelectionItem>, IComboSelectionItem> getFirstFillSelection() {
        return this.firstFillTransf;
    }

    public final void setFirstFillSelection(ITransformer<List<IComboSelectionItem>, IComboSelectionItem> firstFillTransf) {
        this.firstFillTransf = firstFillTransf;
    }

    private boolean isUndefIDEmpty() {
        return this.getRequest().getUndefLabel() == null;
    }

    private boolean isUndefIDEmpty(int id) {
        return this.isUndefIDEmpty() && id == this.getRequest().getPrimaryTable().getUndefinedID();
    }

    private final void uiInit() {
        this.filterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IComboModel.this.fillCombo();
            }
        };
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                    IComboModel.this.itemsChanged();
                }
            }
        });
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        if (index0 == -1 && index1 == -1) {
            this.comboValueChanged();
        }
        super.fireContentsChanged(source, index0, index1);
    }

    public synchronized void setSleepState(ITableModel.SleepState newState) {
        ITableModel.SleepState prev;
        assert (SwingUtilities.isEventDispatchThread());
        if (newState == ITableModel.SleepState.SLEEPING && !this.isSleepAllowed()) {
            newState = ITableModel.SleepState.AWAKE;
        }
        if ((prev = this.sleepState) != newState) {
            this.sleepState = newState;
            if (prev == ITableModel.SleepState.HIBERNATING) {
                this.req.addTableListener(this);
                this.req.addWhereListener(this.filterListener);
                this.isADirtyDrityGirl = true;
            } else if (newState == ITableModel.SleepState.HIBERNATING) {
                this.req.removeTableListener(this);
                this.req.rmWhereListener(this.filterListener);
            }
            if (newState == ITableModel.SleepState.AWAKE && this.isADirtyDrityGirl) {
                this.fillCombo();
            }
        }
    }

    public final ComboSQLRequest getRequest() {
        return this.req;
    }

    public void setDebug(boolean trace) {
        this.debug = trace;
    }

    private void log(String s) {
        if (this.debug) {
            Log.get().info(s);
        }
    }

    public final void setSleepAllowed(boolean sleepAllowed) {
        this.sleepAllowed = sleepAllowed;
    }

    public final boolean isSleepAllowed() {
        return this.sleepAllowed;
    }

    private final synchronized boolean isActive() {
        return this.sleepState == ITableModel.SleepState.AWAKE;
    }

    private final synchronized boolean areValuesObsolete() {
        return this.isUpdating() || !this.isActive();
    }

    public final synchronized int getRequestDelay() {
        return this.requestDelay;
    }

    public final synchronized void setRequestDelay(int delay) {
        this.requestDelay = delay;
    }

    public final void setNonDBItems(List<IComboSelectionItem> nonDBItems) {
        this.setNonDBItems(nonDBItems, null);
    }

    public final synchronized void setNonDBItems(List<IComboSelectionItem> nonDBItems, Runnable r) {
        this.nonDBItems = Collections.unmodifiableList(new ArrayList<IComboSelectionItem>(nonDBItems));
        this.fillCombo(r, FillMode.NO_DB);
    }

    public final void fillCombo() {
        this.fillCombo(null, true);
    }

    public final void fillCombo(Runnable r, boolean readCache) {
        this.fillCombo(r, readCache ? FillMode.DB_WITH_READ_CACHE : FillMode.DB_WITHOUT_READ_CACHE);
    }

    private final synchronized void fillCombo(Runnable r, FillMode fillMode) {
        if (this.isActive() || r != null) {
            this.doUpdateAll(r, fillMode);
        } else {
            this.isADirtyDrityGirl = true;
        }
    }

    private void updateAllBegun() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IComboModel.this.updateAllBegun();
                }
            });
        } else {
            this.log("entering updateAllBegun");
            assert (!this.isUpdating()) : "Otherwise our modeToSelect = DISABLED and setEnabled() would overwrite modeToSelect";
            this.setUpdating(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateAll(Runnable r, FillMode requestedFillMode) {
        this.log("entering doUpdateAll");
        IComboModel iComboModel = this;
        synchronized (iComboModel) {
            FillMode fillMode;
            boolean firstFill;
            this.isADirtyDrityGirl = false;
            boolean bl = firstFill = !this.filledOnce;
            if (this.willUpdate != null) {
                this.willUpdate.cancel(true);
                fillMode = requestedFillMode.compareTo(this.willUpdateMode) < 0 ? requestedFillMode : this.willUpdateMode;
            } else {
                this.updateAllBegun();
                fillMode = firstFill ? (requestedFillMode == FillMode.NO_DB ? FillMode.DB_WITH_READ_CACHE : requestedFillMode) : requestedFillMode;
            }
            if (r != null) {
                this.runnables.add(r);
            }
            final int delay = this.getRequestDelay();
            final SearchSpec search = this.getSearch();
            final List<String> searchQuery = this.getSearchQuery();
            final Where searchForceInclude = this.getSearchForceInclude();
            this.log("will call getComboItems(" + (Object)((Object)fillMode) + ", " + searchQuery + ", " + searchForceInclude + ")");
            final List<IComboSelectionItem> nonDBItems = this.nonDBItems;
            SwingWorker<Tuple2<Integer, List<IComboSelectionItem>>, Object> worker = new SwingWorker<Tuple2<Integer, List<IComboSelectionItem>>, Object>(){

                @Override
                protected Tuple2<Integer, List<IComboSelectionItem>> doInBackground() throws InterruptedException {
                    Thread.sleep(delay);
                    ArrayList<Object> res = new ArrayList<Object>(nonDBItems.size() + 12);
                    res.addAll(SearchSpecUtils.filter(nonDBItems, search));
                    int nonDBCount = res.size();
                    if (fillMode != FillMode.NO_DB) {
                        res.addAll(SearchSpecUtils.filter(IComboModel.this.req.getComboItems(fillMode == FillMode.DB_WITH_READ_CACHE, searchQuery, Locale.getDefault(), searchForceInclude), search));
                    }
                    return Tuple2.create(nonDBCount, res);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void done() {
                    IComboModel iComboModel = IComboModel.this;
                    synchronized (iComboModel) {
                        Tuple2 countAndItems;
                        int idToSelect;
                        block27: {
                            if (this.isCancelled() || IComboModel.this.willUpdate != this) {
                                return;
                            }
                            idToSelect = IComboModel.this.getWantedID();
                            countAndItems = null;
                            try {
                                countAndItems = (Tuple2)this.get();
                                if (fillMode == FillMode.NO_DB) {
                                    IComboModel.this.replaceItems(0, IComboModel.this.nonDBCount, (List)countAndItems.get1());
                                } else {
                                    IComboModel.this.setAllItems((List)countAndItems.get1());
                                }
                                IComboModel.this.nonDBCount = (Integer)countAndItems.get0();
                                IComboModel.this.filledOnce = true;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                    throw new AssertionError();
                                }
                                IComboModel.this.setWillUpdate(null, null);
                                break block27;
                            }
                            catch (CancellationException e) {
                                e.printStackTrace();
                                break block27;
                            }
                            catch (ExecutionException e) {
                                block28: {
                                    if (e.getCause() instanceof RTInterruptedException) break block28;
                                    e.printStackTrace();
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                }
                                if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                    throw new AssertionError();
                                }
                                IComboModel.this.setWillUpdate(null, null);
                                break block27;
                            }
                            {
                                finally {
                                    if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                        throw new AssertionError();
                                    }
                                    IComboModel.this.setWillUpdate(null, null);
                                }
                            }
                            if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                throw new AssertionError();
                            }
                            IComboModel.this.setWillUpdate(null, null);
                        }
                        if (countAndItems != null) {
                            boolean noSelection = idToSelect == -1;
                            List items = IComboModel.this.getComboModel().getList();
                            if (items.size() == 1 && noSelection && Boolean.getBoolean("org.openconcerto.sql.sqlCombo.selectSoleItem")) {
                                IComboModel.this.setSelectedObject((IComboSelectionItem)items.get(0));
                            } else if (noSelection && firstFill && IComboModel.this.getFirstFillSelection() != null) {
                                IComboModel.this.setSelectedObject((IComboSelectionItem)IComboModel.this.getFirstFillSelection().transformChecked(items));
                            } else if (!noSelection && IComboModel.this.getComboItem(idToSelect) == null && !CompareUtils.equals(IComboModel.this.getSearchForceInclude(), searchForceInclude)) {
                                IComboModel.this.fillCombo();
                            } else {
                                IComboModel.this.selectID(idToSelect);
                            }
                            for (Runnable r : IComboModel.this.runnables) {
                                r.run();
                            }
                            IComboModel.this.runnables.clear();
                        }
                    }
                }
            };
            this.setWillUpdate(worker, fillMode);
            worker.execute();
        }
    }

    private DefaultIMutableListModel<IComboSelectionItem> getComboModel() {
        return this;
    }

    private void setAllItems(List<IComboSelectionItem> items) {
        this.getComboModel().setAllElements(items, false);
        this.itemsByID.clear();
        for (IComboSelectionItem item : items) {
            this.indexItem(item);
        }
        assert (this.isSizeCoherent());
    }

    private void replaceItems(int from, int to, List<IComboSelectionItem> items) {
        this.getComboModel().replaceExclusive(from, to, items, false);
        this.itemsByID.clear();
        for (IComboSelectionItem item : this.getComboModel().getList()) {
            this.indexItem(item);
        }
        assert (this.isSizeCoherent());
    }

    private void addItem(IComboSelectionItem item) {
        this.getComboModel().addElement(item);
        this.indexItem(item);
        assert (this.isSizeCoherent());
    }

    private void indexItem(IComboSelectionItem item) {
        IComboSelectionItem prev = this.itemsByID.put(item.getId(), item);
        if (prev != null) {
            throw new IllegalStateException("Duplicate IDs : " + prev + " and " + item);
        }
    }

    private boolean isSizeCoherent() {
        return this.itemsByID.size() == this.getComboModel().getSize();
    }

    private IComboSelectionItem getComboItem(int id) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.itemsByID.get(id);
    }

    public final IComboSelectionItem getItem(int id) {
        IComboSelectionItem privateItem = this.getComboItem(id);
        return privateItem == null ? null : new IComboSelectionItem(privateItem);
    }

    private final void itemsChanged() {
        List newVal = this.getList();
        this.propSupp.firePropertyChange("items", null, newVal);
    }

    @Override
    public final void resetValue() {
        this.setValue(null);
    }

    @Override
    public final void setValue(int id) {
        this.selectID(this.isUndefIDEmpty(id) ? -1 : id);
    }

    @Override
    public final void setValue(IComboSelectionItem o) {
        if (o == null) {
            this.setValue(-1);
        } else {
            this.setValue(o.getId());
        }
    }

    @Override
    public final IComboSelectionItem getValue() {
        Object res = !this.areValuesObsolete() ? this.getSelectedValue() : (this.getWantedID() == -1 ? null : (this.getRequest().getKeepMode() == ComboSQLRequest.KeepMode.NONE ? new IComboSelectionItem(this.getWantedID(), null) : new IComboSelectionItem(new SQLRow(this.getForeignTable(), this.getWantedID()), null)));
        assert (this.getWantedID() != -1 && this.getWantedID() == ((IComboSelectionItem)res).getId() || this.getWantedID() == -1 && res == null);
        return res;
    }

    public final IComboSelectionItem getSelectedValue() {
        return (IComboSelectionItem)this.getSelectedObject();
    }

    public final SQLTable getForeignTable() {
        return this.req.getPrimaryTable();
    }

    public final int getWantedID() {
        return this.idToSelect;
    }

    private final void setWantedID(int id) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.idToSelect != id) {
            int old = this.idToSelect;
            this.idToSelect = id;
            this.setSearchForceInclude(id);
            this.propSupp.firePropertyChange("wantedID", old, id);
            this.propSupp.firePropertyChange("value", null, this.getValue());
            this.emptySupp.fireEmptyChange(this.isEmpty());
        }
    }

    public final int getSelectedId() {
        IComboSelectionItem o = this.getSelectedValue();
        if (o != null) {
            assert (o.getId() != -1);
            return o.getId();
        }
        return -1;
    }

    public final SQLRow getWantedRow() {
        if (this.isEmpty()) {
            return null;
        }
        IComboSelectionItem o = this.getValue();
        SQLRowAccessor r = o.getRow();
        if (r != null) {
            return r.asRow();
        }
        return new SQLRow(this.getForeignTable(), o.getId());
    }

    private final void comboValueChanged() {
        if (!this.isUpdating()) {
            this.setWantedID(this.getSelectedId());
        }
        this.propSupp.firePropertyChange("selectedValue", null, this.getSelectedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectID(int id) {
        this.log("entering selectID " + id);
        assert (SwingUtilities.isEventDispatchThread());
        if (this.areValuesObsolete()) {
            this.setWantedID(id);
            if (!this.isUpdating()) {
                IComboModel iComboModel = this;
                synchronized (iComboModel) {
                    this.isADirtyDrityGirl = true;
                }
            }
            this.log("values are obsolete: wantedID = " + id);
        } else if (id == -1) {
            this.setSelectedObject(null);
            this.log("NONEXISTANT_ID: setSelectedItem(null)");
        } else {
            IComboSelectionItem item = this.getComboItem(id);
            boolean forceIncludeChanged = this.setSearchForceInclude(id);
            this.log("valid id : " + id + " forceIncludeChanged: " + forceIncludeChanged + " item: " + item);
            if (forceIncludeChanged && item == null) {
                this.fillCombo();
                assert (this.isUpdating()) : "If not isUpdating(), getValue() will return the current UI value instead of the wantedID";
                this.setWantedID(id);
            } else if (item == null && this.addMissingItem()) {
                IComboSelectionItem newItem;
                ComboSQLRequest comboSQLRequest = this.req.clone();
                comboSQLRequest.setFilterEnabled(false);
                comboSQLRequest.setWhere(null);
                final ITransformer<SQLSelect, SQLSelect> transf = comboSQLRequest.getSelectTransf();
                if (transf != null) {
                    comboSQLRequest.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        @Override
                        public SQLSelect transformChecked(SQLSelect input) {
                            SQLSelect res = (SQLSelect)transf.transformChecked(input);
                            res.setWhere(null);
                            return res;
                        }
                    });
                }
                if ((newItem = comboSQLRequest.getComboItem(id)) != null) {
                    newItem.setFlag(1);
                } else {
                    new IllegalStateException("ID " + id + " cannot be found in " + this.req).printStackTrace();
                    SQLRow row = new SQLRow(this.req.getPrimaryTable(), id);
                    String error = !row.exists() ? " inexistante" : (row.isArchived() ? " archiv\u00e9e" : " existe mais est non atteignable: " + row.findDistantArchived(2));
                    newItem = new IComboSelectionItem(row, "ERREUR !!! " + row + error);
                    newItem.setFlag(2);
                }
                this.addItem(newItem);
                this.setSelectedObject(newItem);
            } else {
                this.setSelectedObject(item);
            }
        }
    }

    public final boolean addMissingItem() {
        return this.addMissingItem;
    }

    public final void setAddMissingItem(boolean addMissingItem) {
        this.addMissingItem = addMissingItem;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.req;
    }

    public final String dump() {
        String res = this.toString();
        for (IComboSelectionItem it : this.getComboModel().getList()) {
            res = String.valueOf(res) + "\n" + it.dump();
        }
        return res;
    }

    @Override
    public final boolean isEmpty() {
        return this.getWantedID() == -1 || this.isUndefIDEmpty(this.getWantedID());
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.emptySupp.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.emptySupp.removeEmptyListener(l);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.addListener("value", l);
    }

    @Override
    public final void rmValueListener(PropertyChangeListener l) {
        this.rmListener("value", l);
    }

    public final void addListener(String propName, PropertyChangeListener l) {
        this.propSupp.addPropertyChangeListener(propName, l);
    }

    public final void rmListener(String propName, PropertyChangeListener l) {
        this.propSupp.removePropertyChangeListener(propName, l);
    }

    public final void addItemsListener(PropertyChangeListener l) {
        this.addItemsListener(l, false);
    }

    public final void addItemsListener(PropertyChangeListener l, boolean all) {
        this.addListener("items", l);
    }

    public final void rmItemsListener(PropertyChangeListener l) {
        this.rmListener("items", l);
    }

    @Override
    public void tableModified(SQLTableEvent evt) {
        this.fillCombo();
    }

    public final synchronized void search(SearchSpec spec) {
        this.search = spec;
        this.fillCombo();
    }

    private synchronized SearchSpec getSearch() {
        return this.search;
    }

    protected final boolean isFiltered() {
        return this.getSearch() != null && !this.getSearch().isEmpty();
    }

    private synchronized void setWillUpdate(SwingWorker<?, ?> w, FillMode fillMode) {
        this.willUpdate = w;
        this.willUpdateMode = fillMode;
        this.propSupp.firePropertyChange("willUpdate", null, this.willUpdate);
        if (this.willUpdate == null) {
            assert (SwingUtilities.isEventDispatchThread()) : "The end of an update should be in the EDT to be able change swing related attributes";
            this.setUpdating(false);
        }
    }

    private final void setUpdating(boolean b) {
        assert (SwingUtilities.isEventDispatchThread());
        this.updating = b;
        this.propSupp.firePropertyChange("updating", null, (Object)this.updating);
    }

    public final boolean isUpdating() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.updating;
    }

    @Override
    public boolean isSearchable() {
        return this.reqSearchable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSearch(String s, Runnable r) {
        List split = StringUtils.isEmpty(s) ? Collections.emptyList() : Arrays.asList(QUERY_SPLIT_PATTERN.split(s));
        boolean res = false;
        IComboModel iComboModel = this;
        synchronized (iComboModel) {
            if (!split.equals(this.searchQuery)) {
                this.searchQuery = split;
                if (this.isSearchable()) {
                    res = true;
                }
            }
            this.log("setSearch() fillCombo: " + res + " query: " + this.searchQuery);
        }
        if (res) {
            this.fillCombo(r, true);
        } else if (r != null) {
            SwingThreadUtils.invoke(r);
        }
        return res;
    }

    private synchronized List<String> getSearchQuery() {
        assert (this.searchQuery != null) : "Null query means don't use the search which should only be governed by isSearchable()";
        return this.isSearchable() ? this.searchQuery : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSearchForceInclude(int id) {
        boolean changed;
        if (!this.isSearchable()) {
            assert (this.getSearchForceInclude() == null);
            return false;
        }
        Where newVal = id != -1 ? new Where((FieldRef)this.getRequest().getPrimaryTable().getKey(), "=", id) : null;
        IComboModel iComboModel = this;
        synchronized (iComboModel) {
            boolean bl = changed = !CompareUtils.equals(this.searchForceInclude, newVal);
            if (changed) {
                this.searchForceInclude = newVal;
            }
        }
        return changed;
    }

    private synchronized Where getSearchForceInclude() {
        return this.searchForceInclude;
    }

    private static enum FillMode {
        DB_WITHOUT_READ_CACHE,
        DB_WITH_READ_CACHE,
        NO_DB;

    }
}

