/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.utils.SQLUtils;

public class MultipleSQLSelectExecutor {
    private DBSystemRoot root;
    private List<ResultSetHandler> handlers;
    private List<SQLSelect> queries;

    public MultipleSQLSelectExecutor(DBSystemRoot root, List<SQLSelect> queries) {
        this.queries = queries;
        this.root = root;
        int size = queries.size();
        this.handlers = new ArrayList<ResultSetHandler>(size);
        int i = 0;
        while (i < size) {
            this.handlers.add(SQLRowListRSH.createFromSelect(queries.get(i)));
            ++i;
        }
    }

    public List<List<SQLRow>> execute() throws SQLException {
        ArrayList<String> req = new ArrayList<String>(this.queries.size());
        for (SQLSelect query : this.queries) {
            req.add(query.asString());
        }
        List<List<SQLRow>> result = SQLUtils.executeMultiple(this.root, req, this.handlers);
        return result;
    }
}

