/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.HashingStrategy;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.xml.JDOM2Utils;

public final class Link
extends DirectedEdge<SQLTable> {
    private final List<SQLField> cols;
    private final List<String> colsNames;
    private final List<SQLField> refCols;
    private final List<String> refColsNames;
    private final String name;
    private final Rule updateRule;
    private final Rule deleteRule;
    private static final HashingStrategy<Link> INTERSYSTEM_STRATEGY = new HashingStrategy<Link>(){

        @Override
        public boolean equals(Link thisLink, Link otherLink) {
            if (thisLink == otherLink) {
                return true;
            }
            if (thisLink == null || otherLink == null) {
                return false;
            }
            return ((SQLTable)thisLink.getSource()).getName().equals(((SQLTable)otherLink.getSource()).getName()) && thisLink.getCols().equals(otherLink.getCols()) && thisLink.getUpdateRule() == otherLink.getUpdateRule() && thisLink.getDeleteRule() == otherLink.getDeleteRule() && thisLink.getRefCols().equals(otherLink.getRefCols()) && thisLink.getContextualName().equals(otherLink.getContextualName());
        }

        @Override
        public int computeHashCode(Link l) {
            int prime = 31;
            int result = 1;
            result = 31 * result + l.getCols().hashCode();
            result = 31 * result + l.getContextualName().hashCode();
            return result;
        }
    };

    static final Set<SQLField> getSingleFields(Set<Link> links) {
        HashSet<SQLField> res = new HashSet<SQLField>(links.size());
        for (Link l : links) {
            SQLField singleField = l.getSingleField();
            if (singleField != null) {
                res.add(singleField);
                continue;
            }
            return null;
        }
        return res;
    }

    Link(List<SQLField> keys, List<SQLField> referredCols, String foreignKeyName, Rule updateRule, Rule deleteRule) {
        super(keys.get(0).getTable(), referredCols.get(0).getTable());
        if (keys.size() != referredCols.size()) {
            throw new IllegalArgumentException("size mismatch: " + keys + " != " + referredCols);
        }
        this.cols = Collections.unmodifiableList(new ArrayList<SQLField>(keys));
        ArrayList<String> tmpCols = new ArrayList<String>(this.cols.size());
        for (SQLField f : this.cols) {
            tmpCols.add(f.getName());
        }
        this.colsNames = Collections.unmodifiableList(tmpCols);
        this.refCols = Collections.unmodifiableList(new ArrayList<SQLField>(referredCols));
        ArrayList<String> tmpRefCols = new ArrayList<String>(this.refCols.size());
        for (SQLField f : this.refCols) {
            tmpRefCols.add(f.getName());
        }
        this.refColsNames = Collections.unmodifiableList(tmpRefCols);
        this.name = foreignKeyName;
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
    }

    public final List<SQLField> getFields() {
        return this.cols;
    }

    public final SQLField getSingleField() {
        return CollectionUtils.getSole(this.cols);
    }

    public final List<String> getCols() {
        return this.colsNames;
    }

    public final SQLField getLabel() throws IllegalStateException {
        if (this.cols.size() == 1) {
            return this.cols.get(0);
        }
        throw new IllegalStateException(this + " has more than 1 foreign column: " + this.getFields());
    }

    public List<SQLField> getRefFields() {
        return this.refCols;
    }

    public final List<String> getRefCols() {
        return this.refColsNames;
    }

    public final String getName() {
        return this.name;
    }

    public final SQLName getContextualName() {
        return ((SQLTable)this.getTarget()).getContextualSQLName((SQLIdentifier)this.getSource());
    }

    public final Rule getUpdateRule() {
        return this.updateRule;
    }

    public final Rule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public String toString() {
        return "<" + this.getFields() + " -> " + this.getTarget() + (this.getName() != null ? " '" + this.getName() + "'" : "") + ">";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Link o = (Link)other;
        return this.getFields().equals(o.getFields()) && this.getRefFields().equals(o.getRefFields()) && this.getUpdateRule() == o.getUpdateRule() && this.getDeleteRule() == o.getDeleteRule();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getFields().hashCode();
        result = 31 * result + this.getRefFields().hashCode();
        return result;
    }

    public static final HashingStrategy<Link> getInterSystemHashStrategy() {
        return INTERSYSTEM_STRATEGY;
    }

    void toXML(Writer pWriter) throws IOException {
        pWriter.write("  <link to=\"" + JDOM2Utils.OUTPUTTER.escapeAttributeEntities(((SQLTable)this.getTarget()).getSQLName().toString()) + "\" ");
        if (this.getName() != null) {
            pWriter.write("name=\"" + JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getName()) + "\" ");
        }
        if (this.getUpdateRule() != null) {
            pWriter.write("updateRule=\"" + JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getUpdateRule().name()) + "\" ");
        }
        if (this.getDeleteRule() != null) {
            pWriter.write("deleteRule=\"" + JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getDeleteRule().name()) + "\" ");
        }
        if (this.getFields().size() == 1) {
            this.toXML(pWriter, 0);
            pWriter.write("/>\n");
        } else {
            pWriter.write(">\n");
            int i = 0;
            while (i < this.getFields().size()) {
                pWriter.write("    <l ");
                this.toXML(pWriter, i);
                pWriter.write("/>\n");
                ++i;
            }
            pWriter.write("  </link>\n");
        }
    }

    private void toXML(Writer pWriter, int i) throws IOException {
        pWriter.write("col=\"");
        pWriter.write(JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getFields().get(i).getName()));
        pWriter.write("\" refCol=\"");
        pWriter.write(JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getRefFields().get(i).getName()));
        pWriter.write("\"");
    }

    public static Link fromXML(SQLTable t, Element linkElem) {
        SQLName to = SQLName.parse(linkElem.getAttributeValue("to"));
        SQLTable foreignTable = t.getDBSystemRoot().getDesc(to, SQLTable.class);
        String linkName = linkElem.getAttributeValue("name");
        Rule updateRule = Rule.fromName(linkElem.getAttributeValue("updateRule"));
        Rule deleteRule = Rule.fromName(linkElem.getAttributeValue("deleteRule"));
        List<Element> lElems = linkElem.getAttribute("col") != null ? Collections.singletonList(linkElem) : linkElem.getChildren("l");
        ArrayList<SQLField> cols = new ArrayList<SQLField>();
        ArrayList<SQLField> refcols = new ArrayList<SQLField>();
        for (Element l : lElems) {
            cols.add(t.getField(l.getAttributeValue("col")));
            refcols.add(foreignTable.getField(l.getAttributeValue("refCol")));
        }
        return new Link(cols, refcols, linkName, updateRule, deleteRule);
    }

    public static enum Direction {
        FOREIGN{

            @Override
            public Direction reverse() {
                return REFERENT;
            }
        }
        ,
        REFERENT{

            @Override
            public Direction reverse() {
                return FOREIGN;
            }
        }
        ,
        ANY{

            @Override
            public Direction reverse() {
                return this;
            }
        };


        public abstract Direction reverse();

        public static Direction fromForeign(Boolean foreign) {
            if (foreign == null) {
                return ANY;
            }
            return foreign != false ? FOREIGN : REFERENT;
        }
    }

    public static class NamePredicate
    extends IPredicate<Link> {
        private final SQLTable table;
        private final String oppositeRootName;
        private final String oppositeTableName;
        private final List<String> fieldsNames;

        public NamePredicate(SQLTable table, String oppositeTableName) {
            this(table, null, oppositeTableName);
        }

        public NamePredicate(SQLTable table, String oppositeRootName, String oppositeTableName) {
            this(table, oppositeRootName, oppositeTableName, null);
        }

        public NamePredicate(SQLTable table, String oppositeRootName, String oppositeTableName, List<String> fieldsNames) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            this.oppositeRootName = oppositeRootName;
            this.oppositeTableName = oppositeTableName;
            this.fieldsNames = fieldsNames;
        }

        @Override
        public boolean evaluateChecked(Link l) {
            SQLTable oppositeTable = l.oppositeVertex(this.table);
            return !(this.fieldsNames != null && !this.fieldsNames.equals(l.getCols()) || this.oppositeTableName != null && !this.oppositeTableName.equals(oppositeTable.getName()) || this.oppositeRootName != null && !this.oppositeRootName.equals(oppositeTable.getDBRoot().getName()));
        }

        public String toString() {
            String links;
            String string = links = this.fieldsNames == null ? " for links" : " for links through " + this.fieldsNames;
            String tables = this.oppositeRootName == null && this.oppositeTableName == null ? " to/from " + this.table : (this.oppositeTableName == null ? " connecting " + this.table + " and a table in the root " + new SQLName(this.oppositeRootName) : " connecting " + this.table + " and table(s) named " + new SQLName(this.oppositeRootName, this.oppositeTableName));
            return String.valueOf(this.getClass().getSimpleName()) + links + tables;
        }
    }

    public static enum Rule {
        SET_NULL("SET NULL"),
        SET_DEFAULT("SET DEFAULT"),
        CASCADE("CASCADE"),
        RESTRICT("RESTRICT"),
        NO_ACTION("NO ACTION");

        private final String sql;

        private Rule(String sql) {
            this.sql = sql;
        }

        public static Rule fromShort(short s) {
            switch (s) {
                case 0: {
                    return CASCADE;
                }
                case 2: {
                    return SET_NULL;
                }
                case 4: {
                    return SET_DEFAULT;
                }
                case 1: {
                    return RESTRICT;
                }
                case 3: {
                    return NO_ACTION;
                }
            }
            throw new IllegalArgumentException("Unknown rule " + s);
        }

        public static Rule fromName(String n) {
            return n == null ? null : Rule.valueOf(n);
        }

        public String asString() {
            return this.sql;
        }
    }
}

