/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.SetMap;

public class SQLFieldsSet {
    private static final SQLFieldsSet EMPTY = new SQLFieldsSet(SetMap.empty(), true);
    private final CollectionMap2Itf.SetMapItf<SQLTable, SQLField> tables;

    public static SQLFieldsSet empty() {
        return EMPTY;
    }

    public static SQLFieldsSet create(SQLTable t, String ... names) {
        CollectionMap2Itf.SetMapItf<SQLTable, SQLField> res = SQLFieldsSet.createMap();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            res.add(t, t.getField(name));
            ++n2;
        }
        return new SQLFieldsSet(res, false);
    }

    public static SQLFieldsSet create(Map<SQLTable, ? extends Collection<SQLField>> fields) {
        CollectionMap2Itf.SetMapItf<SQLTable, SQLField> res = SQLFieldsSet.createMap();
        res.merge(fields);
        return new SQLFieldsSet(res, false);
    }

    private static final CollectionMap2Itf.SetMapItf<SQLTable, SQLField> toSetMap(Collection<? extends FieldRef> fields) {
        CollectionMap2Itf.SetMapItf<SQLTable, SQLField> res = SQLFieldsSet.createMap();
        for (FieldRef fieldRef : fields) {
            res.add(fieldRef.getField().getTable(), fieldRef.getField());
        }
        return res;
    }

    private static CollectionMap2Itf.SetMapItf<SQLTable, SQLField> createMap() {
        return new SetMap<SQLTable, SQLField>(){

            @Override
            public Set<SQLField> createCollection(Collection<? extends SQLField> v) {
                LinkedHashSet<SQLField> res = new LinkedHashSet<SQLField>(8);
                res.addAll(v);
                return res;
            }
        };
    }

    public static final Set<String> getNames(Collection<SQLField> fields) {
        return SQLFieldsSet.getNames(fields, new HashSet(fields.size()));
    }

    public static final <C extends Collection<String>> C getNames(Collection<SQLField> fields, C res) {
        for (SQLField f : fields) {
            res.add((String)f.getName());
        }
        return res;
    }

    public SQLFieldsSet(Collection<? extends FieldRef> fields) {
        this(SQLFieldsSet.toSetMap(fields), false);
    }

    private SQLFieldsSet(CollectionMap2Itf.SetMapItf<SQLTable, SQLField> fields, boolean unmodif) {
        this.tables = unmodif ? fields : SetMap.unmodifiableMap(fields);
    }

    public final CollectionMap2Itf.SetMapItf<SQLTable, SQLField> getFields() {
        return this.tables;
    }

    public final Set<SQLField> getFields(SQLTable table) {
        return (Set)this.tables.getNonNull(table);
    }

    public final Set<SQLField> getFields(String table) {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLTable t : this.getTables()) {
            if (!t.getName().equals(table)) continue;
            res.addAll(this.getFields(t));
        }
        return res;
    }

    public final Set<String> getFieldsNames(SQLTable table) {
        return SQLFieldsSet.getNames(this.getFields(table));
    }

    public final Set<SQLTable> getTables() {
        return this.tables.keySet();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.tables;
    }
}

